/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.DataBuffers;
import btools.codec.NoisyDiffCoder;
import btools.codec.StatCoderContext;
import btools.codec.TagValueCoder;
import btools.codec.TagValueValidator;
import btools.codec.TagValueWrapper;
import btools.codec.WaypointMatcher;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodesMap;
import btools.mapaccess.TurnRestriction;
import btools.util.ByteDataWriter;

public final class DirectWeaver
extends ByteDataWriter {
    private long id64Base;
    private int size = 0;
    private static final long[] id32_00 = new long[1024];
    private static final long[] id32_10 = new long[1024];
    private static final long[] id32_20 = new long[1024];

    public DirectWeaver(DataBuffers dataBuffers, int lonIdx, int latIdx, int divisor, TagValueValidator wayValidator, WaypointMatcher waypointMatcher, OsmNodesMap hollowNodes) throws Exception {
        super(null);
        int cellsize = 1000000 / divisor;
        this.id64Base = (long)(lonIdx * cellsize) << 32 | (long)(latIdx * cellsize);
        StatCoderContext bc = new StatCoderContext(dataBuffers.iobuffer);
        TagValueCoder wayTagCoder = new TagValueCoder(bc, dataBuffers, wayValidator);
        TagValueCoder nodeTagCoder = new TagValueCoder(bc, dataBuffers, null);
        NoisyDiffCoder nodeIdxDiff = new NoisyDiffCoder(bc);
        NoisyDiffCoder nodeEleDiff = new NoisyDiffCoder(bc);
        NoisyDiffCoder extLonDiff = new NoisyDiffCoder(bc);
        NoisyDiffCoder extLatDiff = new NoisyDiffCoder(bc);
        NoisyDiffCoder transEleDiff = new NoisyDiffCoder(bc);
        this.size = bc.decodeNoisyNumber(5);
        int[] faid = this.size > dataBuffers.ibuf2.length ? new int[this.size] : dataBuffers.ibuf2;
        bc.decodeSortedArray(faid, 0, this.size, 29, 0);
        OsmNode[] nodes = new OsmNode[this.size];
        for (int n = 0; n < this.size; ++n) {
            int ilat;
            long id = this.expandId(faid[n]);
            int ilon = (int)(id >> 32);
            OsmNode node = hollowNodes.get(ilon, ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL));
            if (node == null) {
                node = new OsmNode(ilon, ilat);
            } else {
                node.visitID = 1;
                hollowNodes.remove(node);
            }
            nodes[n] = node;
        }
        int netdatasize = bc.decodeNoisyNumber(10);
        this.ab = dataBuffers.bbuf1;
        this.aboffset = 0;
        int selev = 0;
        for (int n = 0; n < this.size; ++n) {
            int featureId;
            OsmNode node = nodes[n];
            int ilon = node.ilon;
            int ilat = node.ilat;
            short trExceptions = 0;
            while ((featureId = bc.decodeVarBits()) != 0) {
                int bitsize = bc.decodeNoisyNumber(5);
                if (featureId == 2) {
                    trExceptions = (short)bc.decodeBounded(1023);
                    continue;
                }
                if (featureId == 1) {
                    TurnRestriction tr = new TurnRestriction();
                    tr.exceptions = trExceptions;
                    trExceptions = 0;
                    tr.isPositive = bc.decodeBit();
                    tr.fromLon = ilon + bc.decodeNoisyDiff(10);
                    tr.fromLat = ilat + bc.decodeNoisyDiff(10);
                    tr.toLon = ilon + bc.decodeNoisyDiff(10);
                    tr.toLat = ilat + bc.decodeNoisyDiff(10);
                    node.addTurnRestriction(tr);
                    continue;
                }
                for (int i = 0; i < bitsize; ++i) {
                    bc.decodeBit();
                }
            }
            node.selev = (short)(selev += nodeEleDiff.decodeSignedValue());
            TagValueWrapper nodeTags = nodeTagCoder.decodeTagValueSet();
            node.nodeDescription = nodeTags == null ? null : nodeTags.data;
            int links = bc.decodeNoisyNumber(1);
            for (int li = 0; li < links; ++li) {
                int dlat_remaining;
                int dlon_remaining;
                int nodeIdx = n + nodeIdxDiff.decodeSignedValue();
                boolean isReverse = false;
                if (nodeIdx != n) {
                    dlon_remaining = nodes[nodeIdx].ilon - ilon;
                    dlat_remaining = nodes[nodeIdx].ilat - ilat;
                } else {
                    isReverse = bc.decodeBit();
                    dlon_remaining = extLonDiff.decodeSignedValue();
                    dlat_remaining = extLatDiff.decodeSignedValue();
                }
                TagValueWrapper wayTags = wayTagCoder.decodeTagValueSet();
                int linklon = ilon + dlon_remaining;
                int linklat = ilat + dlat_remaining;
                this.aboffset = 0;
                if (!isReverse) {
                    WaypointMatcher matcher = wayTags == null || wayTags.accessType < 2 ? null : waypointMatcher;
                    int ilontarget = ilon + dlon_remaining;
                    int ilattarget = ilat + dlat_remaining;
                    if (matcher != null && !matcher.start(ilon, ilat, ilontarget, ilattarget)) {
                        matcher = null;
                    }
                    int transcount = bc.decodeVarBits();
                    int count = transcount + 1;
                    for (int i = 0; i < transcount; ++i) {
                        int dlon = bc.decodePredictedValue(dlon_remaining / count);
                        int dlat = bc.decodePredictedValue(dlat_remaining / count);
                        dlon_remaining -= dlon;
                        dlat_remaining -= dlat;
                        --count;
                        int elediff = transEleDiff.decodeSignedValue();
                        if (wayTags != null) {
                            this.writeVarLengthSigned(dlon);
                            this.writeVarLengthSigned(dlat);
                            this.writeVarLengthSigned(elediff);
                        }
                        if (matcher == null) continue;
                        matcher.transferNode(ilontarget - dlon_remaining, ilattarget - dlat_remaining);
                    }
                    if (matcher != null) {
                        matcher.end();
                    }
                }
                if (wayTags == null) continue;
                byte[] geometry = null;
                if (this.aboffset > 0) {
                    geometry = new byte[this.aboffset];
                    System.arraycopy(this.ab, 0, geometry, 0, this.aboffset);
                }
                if (nodeIdx != n) {
                    OsmLink link;
                    OsmNode node2 = nodes[nodeIdx];
                    OsmNode osmNode = node.isLinkUnused() ? node : (link = node2.isLinkUnused() ? node2 : null);
                    if (link == null) {
                        link = new OsmLink();
                    }
                    link.descriptionBitmap = wayTags.data;
                    link.geometry = geometry;
                    node.addLink(link, isReverse, node2);
                    continue;
                }
                node.addLink(linklon, linklat, wayTags.data, geometry, hollowNodes, isReverse);
                node.visitID = 1;
            }
        }
        hollowNodes.cleanupAndCount(nodes);
    }

    private static long _expandId(int id32) {
        int dlon = 0;
        int dlat = 0;
        for (int bm = 1; bm < 32768; bm <<= 1) {
            if ((id32 & 1) != 0) {
                dlon |= bm;
            }
            if ((id32 & 2) != 0) {
                dlat |= bm;
            }
            id32 >>= 2;
        }
        return (long)dlon << 32 | (long)dlat;
    }

    public long expandId(int id32) {
        return this.id64Base + id32_00[id32 & 0x3FF] + id32_10[id32 >> 10 & 0x3FF] + id32_20[id32 >> 20 & 0x3FF];
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            DirectWeaver.id32_00[i] = DirectWeaver._expandId(i);
            DirectWeaver.id32_10[i] = DirectWeaver._expandId(i << 10);
            DirectWeaver.id32_20[i] = DirectWeaver._expandId(i << 20);
        }
    }
}

