/*
 * Decompiled with CFR 0.152.
 */
package btools.expressions;

import btools.expressions.BExpression;
import btools.expressions.BExpressionLookupValue;
import btools.expressions.BExpressionMetaData;
import btools.expressions.CacheNode;
import btools.expressions.VarWrapper;
import btools.util.BitCoderContext;
import btools.util.Crc32;
import btools.util.IByteArrayUnifier;
import btools.util.LruMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;

public abstract class BExpressionContext
implements IByteArrayUnifier {
    private static final String CONTEXT_TAG = "---context:";
    private static final String MODEL_TAG = "---model:";
    private String context;
    private boolean _inOurContext = false;
    private BufferedReader _br = null;
    private boolean _readerDone = false;
    public String _modelClass;
    private Map<String, Integer> lookupNumbers = new HashMap<String, Integer>();
    private ArrayList<BExpressionLookupValue[]> lookupValues = new ArrayList();
    private ArrayList<String> lookupNames = new ArrayList();
    private ArrayList<int[]> lookupHistograms = new ArrayList();
    private boolean[] lookupIdxUsed;
    private boolean lookupDataFrozen = false;
    private int[] lookupData = new int[0];
    private byte[] abBuf = new byte[256];
    private BitCoderContext ctxEndode = new BitCoderContext(this.abBuf);
    private BitCoderContext ctxDecode = new BitCoderContext(new byte[0]);
    private Map<String, Integer> variableNumbers = new HashMap<String, Integer>();
    private float[] variableData;
    private CacheNode probeCacheNode = new CacheNode();
    private LruMap cache;
    private VarWrapper probeVarSet = new VarWrapper();
    private LruMap resultVarCache;
    private List<BExpression> expressionList;
    private int minWriteIdx;
    private int[] buildInVariableIdx;
    private int nBuildInVars;
    private float[] currentVars;
    private int currentVarOffset;
    private BExpressionContext foreignContext;
    private int linenr;
    public BExpressionMetaData meta;
    private boolean lookupDataValid = false;
    private int parsedLines = 0;
    private boolean fixTagsWritten = false;
    private long requests;
    private long requests2;
    private long cachemisses;
    private CacheNode lastCacheNode = new CacheNode();

    protected void setInverseVars() {
        this.currentVarOffset = this.nBuildInVars;
    }

    abstract String[] getBuildInVariableNames();

    public final float getBuildInVariable(int idx) {
        return this.currentVars[idx + this.currentVarOffset];
    }

    protected BExpressionContext(String context, BExpressionMetaData meta) {
        this(context, 4096, meta);
    }

    protected BExpressionContext(String context, int hashSize, BExpressionMetaData meta) {
        this.context = context;
        this.meta = meta;
        if (meta != null) {
            meta.registerListener(context, this);
        }
        if (Boolean.getBoolean("disableExpressionCache")) {
            hashSize = 1;
        }
        if (hashSize > 0) {
            this.cache = new LruMap(4 * hashSize, hashSize);
            this.resultVarCache = new LruMap(4096, 4096);
        }
    }

    public byte[] encode() {
        if (!this.lookupDataValid) {
            throw new IllegalArgumentException("internal error: encoding undefined data?");
        }
        return this.encode(this.lookupData);
    }

    public byte[] encode(int[] ld) {
        BitCoderContext ctx = this.ctxEndode;
        ctx.reset();
        int skippedTags = 0;
        int nonNullTags = 0;
        for (int inum = 1; inum < this.lookupValues.size(); ++inum) {
            int d = ld[inum];
            if (d == 0) {
                ++skippedTags;
                continue;
            }
            ctx.encodeVarBits(skippedTags + 1);
            ++nonNullTags;
            skippedTags = 0;
            int dd = d < 2 ? 7 : (d < 9 ? d - 2 : d - 1);
            ctx.encodeVarBits(dd);
        }
        ctx.encodeVarBits(0);
        if (nonNullTags == 0) {
            return null;
        }
        int len = ctx.getEncodedLength();
        byte[] ab = new byte[len];
        System.arraycopy(this.abBuf, 0, ab, 0, len);
        int[] ld2 = new int[this.lookupValues.size()];
        this.decode(ld2, false, ab);
        for (int inum = 1; inum < this.lookupValues.size(); ++inum) {
            if (ld2[inum] == ld[inum]) continue;
            throw new RuntimeException("assertion failed encoding inum=" + inum + " val=" + ld[inum] + " " + this.getKeyValueDescription(false, ab));
        }
        return ab;
    }

    public void decode(byte[] ab) {
        this.decode(this.lookupData, false, ab);
        this.lookupDataValid = true;
    }

    private void decode(int[] ld, boolean inverseDirection, byte[] ab) {
        int delta;
        BitCoderContext ctx = this.ctxDecode;
        ctx.reset(ab);
        ld[0] = inverseDirection ? 2 : 0;
        int inum = 1;
        while ((delta = ctx.decodeVarBits()) != 0 && inum + delta <= ld.length) {
            int d;
            while (delta-- > 1) {
                ld[inum++] = 0;
            }
            int dd = ctx.decodeVarBits();
            int n = dd == 7 ? 1 : (d = dd < 7 ? dd + 2 : dd + 1);
            if (d >= this.lookupValues.get(inum).length) {
                d = 1;
            }
            ld[inum++] = d;
        }
        while (inum < ld.length) {
            ld[inum++] = 0;
        }
    }

    public String getKeyValueDescription(boolean inverseDirection, byte[] ab) {
        StringBuilder sb = new StringBuilder(200);
        this.decode(this.lookupData, inverseDirection, ab);
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            BExpressionLookupValue[] va = this.lookupValues.get(inum);
            String value = va[this.lookupData[inum]].toString();
            if (value == null || value.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(this.lookupNames.get(inum) + "=" + value);
        }
        return sb.toString();
    }

    public List<String> getKeyValueList(boolean inverseDirection, byte[] ab) {
        ArrayList<String> res = new ArrayList<String>();
        this.decode(this.lookupData, inverseDirection, ab);
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            BExpressionLookupValue[] va = this.lookupValues.get(inum);
            String value = va[this.lookupData[inum]].toString();
            if (value == null || value.length() <= 0) continue;
            res.add(this.lookupNames.get(inum));
            res.add(value);
        }
        return res;
    }

    public void parseMetaLine(String line) {
        ++this.parsedLines;
        StringTokenizer tk = new StringTokenizer(line, " ");
        String name = tk.nextToken();
        String value = tk.nextToken();
        int idx = name.indexOf(59);
        if (idx >= 0) {
            name = name.substring(0, idx);
        }
        if (!this.fixTagsWritten) {
            this.fixTagsWritten = true;
            if ("way".equals(this.context)) {
                this.addLookupValue("reversedirection", "yes", null);
            } else if ("node".equals(this.context)) {
                this.addLookupValue("nodeaccessgranted", "yes", null);
            }
        }
        if ("reversedirection".equals(name)) {
            return;
        }
        if ("nodeaccessgranted".equals(name)) {
            return;
        }
        BExpressionLookupValue newValue = this.addLookupValue(name, value, null);
        while (newValue != null && tk.hasMoreTokens()) {
            newValue.addAlias(tk.nextToken());
        }
    }

    public void finishMetaParsing() {
        if (this.parsedLines == 0 && !"global".equals(this.context)) {
            throw new IllegalArgumentException("lookup table does not contain data for context " + this.context + " (old version?)");
        }
        this.lookupDataFrozen = true;
        this.lookupIdxUsed = new boolean[this.lookupValues.size()];
    }

    public final void evaluate(int[] lookupData2) {
        this.lookupData = lookupData2;
        this.evaluate();
    }

    private void evaluate() {
        int n = this.expressionList.size();
        for (int expidx = 0; expidx < n; ++expidx) {
            this.expressionList.get(expidx).evaluate(this);
        }
    }

    public String cacheStats() {
        return "requests=" + this.requests + " requests2=" + this.requests2 + " cachemisses=" + this.cachemisses;
    }

    @Override
    public final byte[] unify(byte[] ab, int offset, int len) {
        byte[] cab;
        this.probeCacheNode.ab = null;
        this.probeCacheNode.hash = Crc32.crc(ab, offset, len);
        CacheNode cn = (CacheNode)this.cache.get(this.probeCacheNode);
        if (cn != null && (cab = cn.ab).length == len) {
            for (int i = 0; i < len; ++i) {
                if (cab[i] == ab[i + offset]) continue;
                cn = null;
                break;
            }
            if (cn != null) {
                this.lastCacheNode = cn;
                return cn.ab;
            }
        }
        byte[] nab = new byte[len];
        System.arraycopy(ab, offset, nab, 0, len);
        return nab;
    }

    public final void evaluate(boolean inverseDirection, byte[] ab) {
        CacheNode cn;
        ++this.requests;
        this.lookupDataValid = false;
        if (this.cache == null) {
            this.decode(this.lookupData, inverseDirection, ab);
            if (this.currentVars == null || this.currentVars.length != this.nBuildInVars) {
                this.currentVars = new float[this.nBuildInVars];
            }
            this.evaluateInto(this.currentVars, 0);
            this.currentVarOffset = 0;
            return;
        }
        if (this.lastCacheNode.ab == ab) {
            cn = this.lastCacheNode;
        } else {
            this.probeCacheNode.ab = ab;
            this.probeCacheNode.hash = Crc32.crc(ab, 0, ab.length);
            cn = (CacheNode)this.cache.get(this.probeCacheNode);
        }
        if (cn == null) {
            ++this.cachemisses;
            cn = (CacheNode)this.cache.removeLru();
            if (cn == null) {
                cn = new CacheNode();
            }
            cn.hash = this.probeCacheNode.hash;
            cn.ab = ab;
            this.cache.put(cn);
            if (this.probeVarSet.vars == null) {
                this.probeVarSet.vars = new float[2 * this.nBuildInVars];
            }
            this.decode(this.lookupData, false, ab);
            this.evaluateInto(this.probeVarSet.vars, 0);
            this.lookupData[0] = 2;
            this.evaluateInto(this.probeVarSet.vars, this.nBuildInVars);
            this.probeVarSet.hash = Arrays.hashCode(this.probeVarSet.vars);
            VarWrapper vw = (VarWrapper)this.resultVarCache.get(this.probeVarSet);
            if (vw == null) {
                vw = (VarWrapper)this.resultVarCache.removeLru();
                if (vw == null) {
                    vw = new VarWrapper();
                }
                vw.hash = this.probeVarSet.hash;
                vw.vars = this.probeVarSet.vars;
                this.probeVarSet.vars = null;
                this.resultVarCache.put(vw);
            }
            cn.vars = vw.vars;
        } else {
            if (ab == cn.ab) {
                ++this.requests2;
            }
            this.cache.touch(cn);
        }
        this.currentVars = cn.vars;
        this.currentVarOffset = inverseDirection ? this.nBuildInVars : 0;
    }

    private void evaluateInto(float[] vars, int offset) {
        this.evaluate();
        for (int vi = 0; vi < this.nBuildInVars; ++vi) {
            int idx = this.buildInVariableIdx[vi];
            vars[vi + offset] = idx == -1 ? 0.0f : this.variableData[idx];
        }
    }

    public void dumpStatistics() {
        int[] histo;
        TreeMap<String, String> counts = new TreeMap<String, String>();
        for (String name : this.lookupNumbers.keySet()) {
            int cnt = 0;
            int inum = this.lookupNumbers.get(name);
            histo = this.lookupHistograms.get(inum);
            for (int i = 2; i < histo.length; ++i) {
                cnt += histo[i];
            }
            counts.put("" + (1000000000 + cnt) + "_" + name, name);
        }
        while (counts.size() > 0) {
            int i;
            String name;
            String key = (String)counts.lastEntry().getKey();
            name = (String)counts.get(key);
            counts.remove(key);
            int inum = this.lookupNumbers.get(name);
            BExpressionLookupValue[] values = this.lookupValues.get(inum);
            histo = this.lookupHistograms.get(inum);
            if (values.length == 1000) continue;
            Object[] svalues = new String[values.length];
            for (i = 0; i < values.length; ++i) {
                String scnt = "0000000000" + histo[i];
                scnt = scnt.substring(scnt.length() - 10);
                svalues[i] = scnt + " " + values[i].toString();
            }
            Arrays.sort(svalues);
            for (i = svalues.length - 1; i >= 0; --i) {
                System.out.println(name + ";" + (String)svalues[i]);
            }
        }
    }

    public int[] createNewLookupData() {
        if (this.lookupDataFrozen) {
            return new int[this.lookupValues.size()];
        }
        return null;
    }

    public int[] generateRandomValues(Random rnd) {
        int[] data = this.createNewLookupData();
        data[0] = 2 * rnd.nextInt(2);
        for (int inum = 1; inum < data.length; ++inum) {
            int nvalues = this.lookupValues.get(inum).length;
            data[inum] = 0;
            if (inum > 1 && rnd.nextInt(10) > 0) continue;
            data[inum] = rnd.nextInt(nvalues);
        }
        this.lookupDataValid = true;
        return data;
    }

    public void assertAllVariablesEqual(BExpressionContext other) {
        int nv = this.variableData.length;
        int nv2 = other.variableData.length;
        if (nv != nv2) {
            throw new RuntimeException("mismatch in variable-count: " + nv + "<->" + nv2);
        }
        for (int i = 0; i < nv; ++i) {
            if (this.variableData[i] == other.variableData[i]) continue;
            throw new RuntimeException("mismatch in variable " + this.variableName(i) + " " + this.variableData[i] + "<->" + other.variableData[i] + "\ntags = " + this.getKeyValueDescription(false, this.encode()));
        }
    }

    private String variableName(int idx) {
        for (Map.Entry<String, Integer> e : this.variableNumbers.entrySet()) {
            if (e.getValue() != idx) continue;
            return e.getKey();
        }
        throw new RuntimeException("no variable for index" + idx);
    }

    public BExpressionLookupValue addLookupValue(String name, String value, int[] lookupData2) {
        BExpressionLookupValue v;
        int i;
        BExpressionLookupValue newValue = null;
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            if (lookupData2 != null) {
                return newValue;
            }
            num = new Integer(this.lookupValues.size());
            this.lookupNumbers.put(name, num);
            this.lookupNames.add(name);
            this.lookupValues.add(new BExpressionLookupValue[]{new BExpressionLookupValue(""), new BExpressionLookupValue("unknown")});
            this.lookupHistograms.add(new int[2]);
            int[] ndata = new int[this.lookupData.length + 1];
            System.arraycopy(this.lookupData, 0, ndata, 0, this.lookupData.length);
            this.lookupData = ndata;
        }
        int inum = num;
        BExpressionLookupValue[] values = this.lookupValues.get(inum);
        int[] histo = this.lookupHistograms.get(inum);
        for (i = 0; i < values.length && !(v = values[i]).matches(value); ++i) {
        }
        if (i == values.length) {
            if (lookupData2 != null) {
                lookupData2[inum] = 1;
                return newValue;
            }
            if (i == 499) {
                // empty if block
            }
            if (i == 500) {
                return newValue;
            }
            BExpressionLookupValue[] nvalues = new BExpressionLookupValue[values.length + 1];
            int[] nhisto = new int[values.length + 1];
            System.arraycopy(values, 0, nvalues, 0, values.length);
            System.arraycopy(histo, 0, nhisto, 0, histo.length);
            values = nvalues;
            histo = nhisto;
            values[i] = newValue = new BExpressionLookupValue(value);
            this.lookupHistograms.set(inum, histo);
            this.lookupValues.set(inum, values);
        }
        int n = i;
        histo[n] = histo[n] + 1;
        if (lookupData2 != null) {
            lookupData2[inum] = i;
        } else {
            this.lookupData[inum] = i;
        }
        return newValue;
    }

    public void addLookupValue(String name, int valueIndex) {
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            return;
        }
        int inum = num;
        int nvalues = this.lookupValues.get(inum).length;
        if (valueIndex < 0 || valueIndex >= nvalues) {
            throw new IllegalArgumentException("value index out of range for name " + name + ": " + valueIndex);
        }
        this.lookupData[inum] = valueIndex;
    }

    public void addSmallestLookupValue(String name, int valueIndex) {
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            return;
        }
        int inum = num;
        int nvalues = this.lookupValues.get(inum).length;
        int oldValueIndex = this.lookupData[inum];
        if (oldValueIndex > 1 && oldValueIndex < valueIndex) {
            return;
        }
        if (valueIndex >= nvalues) {
            valueIndex = nvalues - 1;
        }
        if (valueIndex < 0) {
            throw new IllegalArgumentException("value index out of range for name " + name + ": " + valueIndex);
        }
        this.lookupData[inum] = valueIndex;
    }

    public boolean getBooleanLookupValue(String name) {
        Integer num = this.lookupNumbers.get(name);
        return num != null && this.lookupData[num] == 2;
    }

    public int getOutputVariableIndex(String name, boolean mustExist) {
        int idx = this.getVariableIdx(name, false);
        if (idx < 0) {
            if (mustExist) {
                throw new IllegalArgumentException("unknown variable: " + name);
            }
        } else if (idx < this.minWriteIdx) {
            throw new IllegalArgumentException("bad access to global variable: " + name);
        }
        for (int i = 0; i < this.nBuildInVars; ++i) {
            if (this.buildInVariableIdx[i] != idx) continue;
            return i;
        }
        int[] extended = new int[this.nBuildInVars + 1];
        System.arraycopy(this.buildInVariableIdx, 0, extended, 0, this.nBuildInVars);
        extended[this.nBuildInVars] = idx;
        this.buildInVariableIdx = extended;
        return this.nBuildInVars++;
    }

    public void setForeignContext(BExpressionContext foreignContext) {
        this.foreignContext = foreignContext;
    }

    public float getForeignVariableValue(int foreignIndex) {
        return this.foreignContext.getBuildInVariable(foreignIndex);
    }

    public int getForeignVariableIdx(String context, String name) {
        if (this.foreignContext == null || !context.equals(this.foreignContext.context)) {
            throw new IllegalArgumentException("unknown foreign context: " + context);
        }
        return this.foreignContext.getOutputVariableIndex(name, true);
    }

    public void parseFile(File file, String readOnlyContext) {
        if (!file.exists()) {
            throw new IllegalArgumentException("profile " + file + " does not exist");
        }
        try {
            if (readOnlyContext != null) {
                this.linenr = 1;
                String realContext = this.context;
                this.context = readOnlyContext;
                this.expressionList = this._parseFile(file);
                this.variableData = new float[this.variableNumbers.size()];
                this.evaluate(this.lookupData);
                this.context = realContext;
            }
            this.linenr = 1;
            this.minWriteIdx = this.variableData == null ? 0 : this.variableData.length;
            this.expressionList = this._parseFile(file);
            String[] varNames = this.getBuildInVariableNames();
            this.nBuildInVars = varNames.length;
            this.buildInVariableIdx = new int[this.nBuildInVars];
            for (int vi = 0; vi < varNames.length; ++vi) {
                this.buildInVariableIdx[vi] = this.getVariableIdx(varNames[vi], false);
            }
            float[] readOnlyData = this.variableData;
            this.variableData = new float[this.variableNumbers.size()];
            for (int i = 0; i < this.minWriteIdx; ++i) {
                this.variableData[i] = readOnlyData[i];
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new IllegalArgumentException("ParseException at line " + this.linenr + ": " + e.getMessage());
            }
            throw new RuntimeException(e);
        }
        if (this.expressionList.size() == 0) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " does not contain expressions for context " + this.context + " (old version?)");
        }
    }

    private List<BExpression> _parseFile(File file) throws Exception {
        BExpression exp;
        this._br = new BufferedReader(new FileReader(file));
        this._readerDone = false;
        ArrayList<BExpression> result = new ArrayList<BExpression>();
        while ((exp = BExpression.parse(this, 0)) != null) {
            result.add(exp);
        }
        this._br.close();
        this._br = null;
        return result;
    }

    public float getVariableValue(String name, float defaultValue) {
        Integer num = this.variableNumbers.get(name);
        return num == null ? defaultValue : this.getVariableValue(num);
    }

    float getVariableValue(int variableIdx) {
        return this.variableData[variableIdx];
    }

    int getVariableIdx(String name, boolean create) {
        Integer num = this.variableNumbers.get(name);
        if (num == null) {
            if (create) {
                num = new Integer(this.variableNumbers.size());
                this.variableNumbers.put(name, num);
            } else {
                return -1;
            }
        }
        return num;
    }

    int getMinWriteIdx() {
        return this.minWriteIdx;
    }

    float getLookupMatch(int nameIdx, int[] valueIdxArray) {
        for (int i = 0; i < valueIdxArray.length; ++i) {
            if (this.lookupData[nameIdx] != valueIdxArray[i]) continue;
            return 1.0f;
        }
        return 0.0f;
    }

    public int getLookupNameIdx(String name) {
        Integer num = this.lookupNumbers.get(name);
        return num == null ? -1 : num;
    }

    public final void markLookupIdxUsed(int idx) {
        this.lookupIdxUsed[idx] = true;
    }

    public final boolean isLookupIdxUsed(int idx) {
        return idx < this.lookupIdxUsed.length ? this.lookupIdxUsed[idx] : false;
    }

    public final void setAllTagsUsed() {
        for (int i = 0; i < this.lookupIdxUsed.length; ++i) {
            this.lookupIdxUsed[i] = true;
        }
    }

    int getLookupValueIdx(int nameIdx, String value) {
        BExpressionLookupValue[] values = this.lookupValues.get(nameIdx);
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    String parseToken() throws Exception {
        String token;
        while (true) {
            if ((token = this._parseToken()) == null) {
                return null;
            }
            if (token.startsWith(CONTEXT_TAG)) {
                this._inOurContext = token.substring(CONTEXT_TAG.length()).equals(this.context);
                continue;
            }
            if (token.startsWith(MODEL_TAG)) {
                this._modelClass = token.substring(MODEL_TAG.length()).trim();
                continue;
            }
            if (this._inOurContext) break;
        }
        return token;
    }

    private String _parseToken() throws Exception {
        StringBuilder sb = new StringBuilder(32);
        boolean inComment = false;
        while (true) {
            int ic;
            int n = ic = this._readerDone ? -1 : this._br.read();
            if (ic < 0) {
                if (sb.length() == 0) {
                    return null;
                }
                this._readerDone = true;
                return sb.toString();
            }
            char c = (char)ic;
            if (c == '\n') {
                ++this.linenr;
            }
            if (inComment) {
                if (c != '\r' && c != '\n') continue;
                inComment = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                return sb.toString();
            }
            if (c == '#' && sb.length() == 0) {
                inComment = true;
                continue;
            }
            sb.append(c);
        }
    }

    float assign(int variableIdx, float value) {
        this.variableData[variableIdx] = value;
        return value;
    }
}

