/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.expressions.BExpressionContextNode;
import btools.expressions.BExpressionContextWay;
import btools.expressions.BExpressionMetaData;
import btools.router.RoutingContext;
import java.io.File;

public final class ProfileCache {
    private static BExpressionContextWay expctxWay;
    private static BExpressionContextNode expctxNode;
    private static File lastLookupFile;
    private static File lastProfileFile;
    private static long lastLookupTimestamp;
    private static long lastProfileTimestamp;
    private static boolean profilesBusy;

    public static synchronized boolean parseProfile(RoutingContext rc) {
        File profileFile;
        File profileDir;
        String profileBaseDir = System.getProperty("profileBaseDir");
        if (profileBaseDir == null) {
            profileDir = new File(rc.localFunction).getParentFile();
            profileFile = new File(rc.localFunction);
        } else {
            profileDir = new File(profileBaseDir);
            profileFile = new File(profileDir, rc.localFunction + ".brf");
        }
        rc.profileTimestamp = profileFile.lastModified();
        File lookupFile = new File(profileDir, "lookups.dat");
        if (expctxWay != null && expctxNode != null && !profilesBusy && profileFile.equals(lastProfileFile) && lookupFile.equals(lastLookupFile) && rc.profileTimestamp == lastProfileTimestamp && lookupFile.lastModified() == lastLookupTimestamp) {
            rc.expctxWay = expctxWay;
            rc.expctxNode = expctxNode;
            profilesBusy = true;
            rc.readGlobalConfig();
            return true;
        }
        BExpressionMetaData meta = new BExpressionMetaData();
        rc.expctxWay = new BExpressionContextWay(rc.memoryclass * 512, meta);
        rc.expctxNode = new BExpressionContextNode(0, meta);
        rc.expctxNode.setForeignContext(rc.expctxWay);
        meta.readMetaData(new File(profileDir, "lookups.dat"));
        rc.expctxWay.parseFile(profileFile, "global");
        rc.expctxNode.parseFile(profileFile, "global");
        rc.readGlobalConfig();
        if (rc.processUnusedTags) {
            rc.expctxWay.setAllTagsUsed();
        }
        lastProfileTimestamp = profileFile.lastModified();
        lastLookupTimestamp = lookupFile.lastModified();
        lastProfileFile = profileFile;
        lastLookupFile = lookupFile;
        expctxWay = rc.expctxWay;
        expctxNode = rc.expctxNode;
        profilesBusy = true;
        return false;
    }

    public static synchronized void releaseProfile(RoutingContext rc) {
        if (rc.expctxWay == expctxWay && rc.expctxNode == expctxNode) {
            profilesBusy = false;
        }
        rc.expctxWay = null;
        rc.expctxNode = null;
    }
}

