/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.router.KinematicModel;
import btools.router.KinematicPrePath;
import btools.router.OsmPath;
import btools.router.OsmPrePath;
import btools.router.RoutingContext;

final class KinematicPath
extends OsmPath {
    private double ekin;
    private double totalTime;
    private double totalEnergy;
    private float floatingAngleLeft;
    private float floatingAngleRight;

    KinematicPath() {
    }

    @Override
    protected void init(OsmPath orig) {
        KinematicPath origin = (KinematicPath)orig;
        this.ekin = origin.ekin;
        this.totalTime = origin.totalTime;
        this.totalEnergy = origin.totalEnergy;
        this.floatingAngleLeft = origin.floatingAngleLeft;
        this.floatingAngleRight = origin.floatingAngleRight;
        this.priorityclassifier = origin.priorityclassifier;
    }

    @Override
    protected void resetState() {
        this.ekin = 0.0;
        this.totalTime = 0.0;
        this.totalEnergy = 0.0;
        this.floatingAngleLeft = 0.0f;
        this.floatingAngleRight = 0.0f;
    }

    @Override
    protected double processWaySection(RoutingContext rc, double dist, double delta_h, double angle, double cosangle, boolean isStartpoint, int nsection, int lastpriorityclassifier) {
        KinematicModel km = (KinematicModel)rc.pm;
        double cost = 0.0;
        if (isStartpoint) {
            if (!rc.inverseDirection) {
                cost = 0.5 * (1.0 - cosangle) * 40.0 / km.timecost0;
            }
        } else {
            double turnspeed = 999.0;
            if (km.turnAngleDecayLength != 0.0) {
                double decayFactor = KinematicPath.exp(-dist / km.turnAngleDecayLength);
                this.floatingAngleLeft = (float)((double)this.floatingAngleLeft * decayFactor);
                this.floatingAngleRight = (float)((double)this.floatingAngleRight * decayFactor);
                if (angle < 0.0) {
                    this.floatingAngleLeft -= (float)angle;
                } else {
                    this.floatingAngleRight += (float)angle;
                }
                float aa = Math.max(this.floatingAngleLeft, this.floatingAngleRight);
                if ((double)aa > 130.0) {
                    turnspeed = 0.0;
                } else if ((double)aa > 100.0) {
                    turnspeed = 1.0;
                } else if ((double)aa > 70.0) {
                    turnspeed = 2.0;
                } else if ((double)aa > 50.0) {
                    turnspeed = 4.0;
                } else if ((double)aa > 30.0) {
                    turnspeed = 8.0;
                } else if ((double)aa > 20.0) {
                    turnspeed = 14.0;
                } else if ((double)aa > 10.0) {
                    turnspeed = 20.0;
                }
            }
            if (nsection == 0) {
                int classifiermask = (int)rc.expctxWay.getClassifierMask();
                boolean hasLeftWay = false;
                boolean hasRightWay = false;
                boolean hasResidential = false;
                OsmPrePath prePath = rc.firstPrePath;
                while (prePath != null) {
                    KinematicPrePath pp = (KinematicPrePath)prePath;
                    if (((pp.classifiermask ^ classifiermask) & 8) == 0) {
                        if ((pp.classifiermask & 0x20) != 0) {
                            hasResidential = true;
                        }
                        if (pp.priorityclassifier > this.priorityclassifier || pp.priorityclassifier == this.priorityclassifier && this.priorityclassifier < 20) {
                            double diff = pp.angle - angle;
                            if (diff < -40.0 && diff > -140.0) {
                                hasLeftWay = true;
                            }
                            if (diff > 40.0 && diff < 140.0) {
                                hasRightWay = true;
                            }
                        }
                    }
                    prePath = prePath.next;
                }
                double residentialSpeed = 13.0;
                if (hasLeftWay && turnspeed > km.leftWaySpeed) {
                    turnspeed = km.leftWaySpeed;
                }
                if (hasRightWay && turnspeed > km.rightWaySpeed) {
                    turnspeed = km.rightWaySpeed;
                }
                if (hasResidential && turnspeed > residentialSpeed) {
                    turnspeed = residentialSpeed;
                }
                if (lastpriorityclassifier < 20 ^ this.priorityclassifier < 20) {
                    turnspeed = 0.0;
                }
            }
            this.cutEkin(km.totalweight, turnspeed);
        }
        double distanceCost = this.evolveDistance(km, dist, delta_h);
        if (this.message != null) {
            this.message.costfactor = (float)(distanceCost / dist);
        }
        return cost + distanceCost;
    }

    protected double evolveDistance(KinematicModel km, double dist, double delta_h) {
        double fh = delta_h * km.totalweight * 9.81 / dist;
        double emax = km.getMaxKineticEnergy();
        if (emax <= 0.0) {
            return -1.0;
        }
        double elow = 0.5 * emax;
        double elapsedTime = 0.0;
        double dissipatedEnergy = 0.0;
        double v = Math.sqrt(2.0 * this.ekin / km.totalweight);
        double d = dist;
        while (d > 0.0) {
            double delta_ekin;
            double x;
            boolean slow = this.ekin < elow;
            boolean fast = this.ekin >= emax;
            double etarget = slow ? elow : emax;
            double f = km.f_roll + km.f_air * v * v + fh;
            double f_recup = Math.max(0.0, fast ? -f : (slow ? km.f_recup : 0.0) - fh);
            f += f_recup;
            if (fast) {
                x = d;
                delta_ekin = x * f;
                elapsedTime += x / v;
                this.ekin = etarget;
            } else {
                delta_ekin = etarget - this.ekin;
                double x0 = delta_ekin / f;
                double b = 2.0 * km.f_air / km.totalweight;
                double x0b = x0 * b;
                x = x0 * (1.0 - x0b * (0.5 + x0b * (0.333333333 - x0b * 0.25)));
                double maxstep = Math.min(50.0, d);
                if (x >= maxstep) {
                    x = maxstep;
                    double xb = x * b;
                    delta_ekin = x * f * (1.0 + xb * (0.5 + xb * (0.166666667 + xb * 0.0416666667)));
                    this.ekin += delta_ekin;
                } else {
                    this.ekin = etarget;
                }
                double v2 = Math.sqrt(2.0 * this.ekin / km.totalweight);
                double a = f / km.totalweight;
                elapsedTime += (v2 - v) / a;
                v = v2;
            }
            d -= x;
            dissipatedEnergy += delta_ekin - x * (fh + f_recup * km.recup_efficiency);
        }
        this.totalTime += elapsedTime;
        this.totalEnergy += (dissipatedEnergy += elapsedTime * km.p_standby) + dist * fh;
        return (elapsedTime + km.xweight * dissipatedEnergy) / km.timecost0;
    }

    @Override
    protected double processTargetNode(RoutingContext rc) {
        KinematicModel km = (KinematicModel)rc.pm;
        if (this.targetNode.nodeDescription != null) {
            rc.expctxNode.evaluate(false, this.targetNode.nodeDescription);
            float initialcost = rc.expctxNode.getInitialcost();
            if ((double)initialcost >= 1000000.0) {
                return -1.0;
            }
            this.cutEkin(km.totalweight, km.getNodeMaxspeed());
            if (this.message != null) {
                this.message.linknodecost += (int)initialcost;
                this.message.nodeKeyValues = rc.expctxNode.getKeyValueDescription(false, this.targetNode.nodeDescription);
            }
            return initialcost;
        }
        return 0.0;
    }

    private void cutEkin(double weight, double speed) {
        double e = 0.5 * weight * speed * speed;
        if (this.ekin > e) {
            this.ekin = e;
        }
    }

    private static double exp(double e) {
        double x = e;
        double f = 1.0;
        while (e < -1.0) {
            e += 1.0;
            f *= 0.367879;
        }
        return f * (1.0 + x * (1.0 + x * (0.5 + x * (0.166667 + 0.0416667 * x))));
    }

    @Override
    public int elevationCorrection(RoutingContext rc) {
        return 0;
    }

    @Override
    public boolean definitlyWorseThan(OsmPath path, RoutingContext rc) {
        KinematicPath p = (KinematicPath)path;
        int c = p.cost;
        return this.cost > c + 100;
    }

    @Override
    public double getTotalTime() {
        return this.totalTime;
    }

    @Override
    public double getTotalEnergy() {
        return this.totalEnergy;
    }
}

