/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import btools.mapaccess.OsmPos;
import btools.memrouter.GraphLoader;
import btools.memrouter.Iternity;
import btools.memrouter.OffsetSet;
import btools.memrouter.OsmLinkP;
import btools.memrouter.OsmNodeP;
import btools.memrouter.ScheduledDeparture;
import btools.memrouter.ScheduledLine;
import btools.memrouter.ScheduledLink;
import btools.memrouter.ScheduledTrip;
import btools.memrouter.StationNode;
import btools.router.OsmPathElement;
import btools.router.OsmTrack;
import btools.router.RoutingContext;
import btools.router.RoutingEngine;
import btools.util.SortedHeap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

final class ScheduledRouter {
    private GraphLoader graph;
    public long linksProcessed = 0L;
    public long linksReProcessed = 0L;
    public long closedSkippedChained = 0L;
    public long skippedChained = 0L;
    private RoutingContext rc;
    private RoutingEngine re;
    private long time0;
    private OsmNodeP start;
    private OsmNodeP end;
    SortedHeap<ScheduledTrip> openSet = new SortedHeap();
    private static List<Iternity> trips = new ArrayList<Iternity>();
    private static long oldChecksum = 0L;

    ScheduledRouter(GraphLoader graph, RoutingContext rc, RoutingEngine re) {
        this.graph = graph;
        this.rc = rc;
        this.re = re;
    }

    private String startEndText() {
        return (this.start == null ? "unmatched" : this.start.getName()) + "->" + (this.end == null ? "unmatched" : this.end.getName());
    }

    public OsmTrack findRoute(OsmPos startPos, OsmPos endPos, int alternativeIdx) throws Exception {
        if (alternativeIdx == -1) {
            List<Iternity> singleTrip = this._findRoute(startPos, endPos, true);
            if (singleTrip.isEmpty()) {
                if (this.linksProcessed + this.linksReProcessed > 5000000L) {
                    throw new RuntimeException("5 million links limit reached");
                }
                throw new RuntimeException("no track found! (" + this.startEndText() + ")");
            }
            Iternity iternity = singleTrip.get(0);
            OsmTrack t = iternity.track;
            t.iternity = iternity.details;
            return t;
        }
        long[] nogocheck = this.rc.getNogoChecksums();
        long checksum = nogocheck[0] + nogocheck[1] + nogocheck[2];
        checksum += (long)(startPos.getILat() + startPos.getILon() + endPos.getILat() + endPos.getILon());
        if ((checksum += (long)this.rc.localFunction.hashCode()) != oldChecksum) {
            trips = this._findRoute(startPos, endPos, false);
            Collections.sort(trips);
            oldChecksum = checksum;
        }
        if (trips.isEmpty()) {
            if (this.linksProcessed + this.linksReProcessed > 5000000L) {
                throw new RuntimeException("5 million links limit reached");
            }
            throw new RuntimeException("no track found! (" + this.startEndText() + ")");
        }
        if (alternativeIdx == 0) {
            ArrayList<String> details = new ArrayList<String>();
            for (int idx = 0; idx < trips.size(); ++idx) {
                if (idx > 0) {
                    details.add("");
                }
                Iternity iternity = trips.get(idx);
                iternity.appendSummary(details);
            }
            Iternity iternity = trips.get(0);
            OsmTrack t = iternity.track;
            t.iternity = details;
            return t;
        }
        int idx = alternativeIdx > trips.size() ? trips.size() - 1 : alternativeIdx - 1;
        Iternity iternity = trips.get(idx);
        OsmTrack t = iternity.track;
        t.iternity = iternity.details;
        return t;
    }

    /*
     * Unable to fully structure code
     */
    private List<Iternity> _findRoute(OsmPos startPos, OsmPos endPos, boolean fastStop) throws Exception {
        iternities = new ArrayList<Iternity>();
        this.start = this.graph.matchNodeForPosition(startPos, this.rc.expctxWay, this.rc.transitonly);
        if (this.start == null) {
            throw new IllegalArgumentException("unmatched start: " + startPos);
        }
        this.end = this.graph.matchNodeForPosition(endPos, this.rc.expctxWay, this.rc.transitonly);
        if (this.end == null) {
            throw new IllegalArgumentException("unmatched end: " + endPos);
        }
        this.time0 = System.currentTimeMillis() + (long)(this.rc.starttimeoffset * 60000.0);
        minutes0 = (this.time0 + 59999L) / 60000L;
        this.time0 = minutes0 * 60000L;
        fullSet = OffsetSet.fullSet();
        finishedOffsets = fullSet.emptySet();
        startLink = new OsmLinkP(null, this.start);
        startTrip = new ScheduledTrip(OffsetSet.fullSet(), startLink, null, null);
        this.openSet.add(0, startTrip);
        block0: while (true) {
            if (this.re.isTerminated()) {
                throw new RuntimeException("operation terminated");
            }
            if (this.linksProcessed + this.linksReProcessed > 5000000L || (trip = this.openSet.popLowestKeyValue()) == null) break;
            currentLink = trip.link;
            currentNode = trip.getTargetNode();
            if (currentNode == null) {
                System.out.println("ups: " + trip);
                continue;
            }
            if (currentLink.isVirgin()) {
                ++this.linksProcessed;
            } else {
                ++this.linksReProcessed;
            }
            offsets = trip.offsets;
            offsets = finishedOffsets.filter(offsets);
            if (offsets == null) continue;
            continueOnLineOnly = false;
            if (currentNode.filterAndCloseNode(offsets, true) == null) {
                continueOnLineOnly = true;
            }
            if ((offsets = currentLink.filterAndClose(offsets, trip.arrival)) == null) continue;
            if (currentNode == this.end) {
                iternity = null;
                toffsets = trip.offsets;
                lastIdx = iternities.size() - 1;
                if (lastIdx >= 0 && ((Iternity)iternities.get((int)lastIdx)).track.cost == trip.cost) {
                    toffsets = toffsets.add(((Iternity)iternities.get((int)lastIdx)).offsets);
                    iternities.remove(lastIdx);
                }
                for (offset = 0; offset < trip.offsets.size(); ++offset) {
                    if (!trip.offsets.contains(offset)) continue;
                    iternity = this.compileTrip(trip, offset);
                    iternity.offsets = toffsets;
                    System.out.println("---- begin route ------ (cost " + iternity.track.cost + ")");
                    for (String s : iternity.details) {
                        System.out.println(s);
                    }
                    System.out.println("---- end route ------ (arrival " + new Date(iternity.arrivaltime) + ")");
                    break;
                }
                finishedOffsets = finishedOffsets.add(offsets);
                if (iternity != null && this.efficientSubset(iternities, iternity.offsets, iternity.track.cost) != null) {
                    iternities.add(iternity);
                    if (fastStop) break;
                    System.out.println("*** added track to result list !**** ");
                }
                System.out.println("*** finishedOffsets = " + finishedOffsets);
            }
            link = currentNode.getFirstLink();
            while (true) {
                if (link != null) ** break;
                continue block0;
                if ((!continueOnLineOnly || currentLink instanceof ScheduledLink && link instanceof ScheduledLink && ((ScheduledLink)currentLink).line == ((ScheduledLink)link).line) && (!this.rc.transitonly || link instanceof ScheduledLink)) {
                    this.addNextTripsForLink(trip, currentNode, currentLink, link, offsets, 0);
                }
                link = link.getNext(currentNode);
            }
            break;
        }
        return iternities;
    }

    private OffsetSet efficientSubset(List<Iternity> iternities, OffsetSet offsets, int cost) {
        for (Iternity it : iternities) {
            int dcost = cost - it.track.cost;
            int dtime = (int)((double)dcost * 0.06 / this.rc.cost1speed + 1.0);
            if ((offsets = offsets.sweepWith(it.offsets, dtime)) != null) continue;
            return null;
        }
        return offsets;
    }

    private void addToOpenSet(ScheduledTrip nextTrip) {
        int distance = nextTrip.getTargetNode().calcDistance(this.end);
        nextTrip.adjustedCost = nextTrip.cost + (int)((double)distance * this.rc.pass1coefficient + 0.5);
        this.openSet.add(nextTrip.adjustedCost, nextTrip);
    }

    private void addNextTripsForLink(ScheduledTrip trip, OsmNodeP currentNode, OsmLinkP currentLink, OsmLinkP link, OffsetSet offsets, int level) {
        OsmNodeP node = link.getTarget(currentNode);
        if (node == null) {
            System.out.println("ups2: " + link);
            return;
        }
        if (node == trip.originNode) {
            link.filterAndClose(offsets, -1L);
            return;
        }
        this.rc.nogomatch = false;
        int distance = this.rc.calcDistance(currentNode.ilon, currentNode.ilat, node.ilon, node.ilat);
        if (this.rc.nogomatch) {
            return;
        }
        if (link instanceof ScheduledLink) {
            ScheduledLink slink = (ScheduledLink)link;
            ScheduledLine line = slink.line;
            long delay = 0L;
            if (currentLink instanceof ScheduledLink) {
                delay = ((ScheduledLink)currentLink).line == line ? 0L : (long)(this.rc.changetime * 1000.0);
            }
            long changePenalty = delay > 0L ? 60000L : 0L;
            List<ScheduledDeparture> nextDepartures = line.getScheduledDepartures(slink.indexInLine, this.time0 + trip.arrival + delay, offsets);
            for (ScheduledDeparture nextDeparture : nextDepartures) {
                ScheduledTrip nextTrip = new ScheduledTrip(nextDeparture.offsets, link, currentNode, trip);
                long waitTime = nextDeparture.waitTime + delay;
                long rideTime = nextDeparture.rideTime;
                nextTrip.cost = trip.cost + (int)(((double)(rideTime + changePenalty) + (double)waitTime * this.rc.waittimeadjustment) * this.rc.cost1speed / 3600.0);
                nextTrip.departure = trip.arrival + waitTime;
                nextTrip.arrival = nextTrip.departure + rideTime;
                this.addToOpenSet(nextTrip);
            }
        } else if (link.isWayLink()) {
            int elevationCost;
            int excess;
            int reduce;
            this.rc.expctxWay.evaluate(link.isReverse(currentNode), link.descriptionBitmap);
            float costfactor = this.rc.expctxWay.getCostfactor();
            if ((double)costfactor > 9999.0) {
                return;
            }
            int waycost = (int)((float)distance * costfactor + 0.5f);
            float costdiff = costfactor - trip.lastcostfactor;
            if ((double)costdiff > 5.0E-4 || (double)costdiff < -5.0E-4) {
                waycost += (int)this.rc.expctxWay.getInitialcost();
            }
            if (node.getNodeDecsription() != null) {
                this.rc.expctxNode.evaluate((double)this.rc.expctxWay.getNodeAccessGranted() != 0.0, node.getNodeDecsription());
                float initialcost = this.rc.expctxNode.getInitialcost();
                if ((double)initialcost >= 1000000.0) {
                    return;
                }
                waycost += (int)initialcost;
            }
            if (trip.originNode != null) {
                double angle = this.rc.calcAngle(trip.originNode.ilon, trip.originNode.ilat, currentNode.ilon, currentNode.ilat, node.ilon, node.ilat);
                double cos = 1.0 - this.rc.getCosAngle();
                int turncost = (int)(cos * (double)this.rc.expctxWay.getTurncost() + 0.2);
                waycost += turncost;
            }
            ScheduledTrip nextTrip = new ScheduledTrip(offsets, link, currentNode, trip);
            short ele2 = node.selev;
            short ele1 = trip.selev;
            int elefactor = 250000;
            if (ele2 == Short.MIN_VALUE) {
                ele2 = ele1;
            }
            nextTrip.selev = ele2;
            if (ele1 != Short.MIN_VALUE) {
                nextTrip.ehbd = trip.ehbd + (ele1 - ele2) * elefactor - distance * this.rc.downhillcutoff;
                nextTrip.ehbu = trip.ehbu + (ele2 - ele1) * elefactor - distance * this.rc.uphillcutoff;
            }
            if (nextTrip.ehbd > this.rc.elevationpenaltybuffer) {
                reduce = distance * this.rc.elevationbufferreduce;
                excess = nextTrip.ehbd - this.rc.elevationpenaltybuffer;
                if (reduce > excess) {
                    reduce = excess;
                }
                if (reduce < (excess = nextTrip.ehbd - this.rc.elevationmaxbuffer)) {
                    reduce = excess;
                }
                nextTrip.ehbd -= reduce;
                if (this.rc.downhillcostdiv > 0) {
                    elevationCost = reduce / this.rc.downhillcostdiv;
                    waycost += elevationCost;
                }
            } else if (nextTrip.ehbd < 0) {
                nextTrip.ehbd = 0;
            }
            if (nextTrip.ehbu > this.rc.elevationpenaltybuffer) {
                reduce = distance * this.rc.elevationbufferreduce;
                excess = nextTrip.ehbu - this.rc.elevationpenaltybuffer;
                if (reduce > excess) {
                    reduce = excess;
                }
                if (reduce < (excess = nextTrip.ehbu - this.rc.elevationmaxbuffer)) {
                    reduce = excess;
                }
                nextTrip.ehbu -= reduce;
                if (this.rc.uphillcostdiv > 0) {
                    elevationCost = reduce / this.rc.uphillcostdiv;
                    waycost += elevationCost;
                }
            } else if (nextTrip.ehbu < 0) {
                nextTrip.ehbu = 0;
            }
            nextTrip.lastcostfactor = costfactor;
            nextTrip.cost = trip.cost + (int)((double)waycost * this.rc.additionalcostfactor + 0.5);
            nextTrip.departure = trip.arrival;
            nextTrip.arrival = nextTrip.departure + (long)((double)waycost * 3600.0 / this.rc.cost1speed);
            this.addToOpenSet(nextTrip);
        } else {
            ScheduledTrip nextTrip = new ScheduledTrip(offsets, link, currentNode, trip);
            long delay = (long)(this.rc.buffertime * 1000.0);
            nextTrip.cost = trip.cost + (int)((double)delay * this.rc.waittimeadjustment * this.rc.cost1speed / 3600.0);
            nextTrip.departure = trip.arrival;
            nextTrip.arrival = nextTrip.departure + delay;
            this.addToOpenSet(nextTrip);
        }
    }

    private Iternity compileTrip(ScheduledTrip trip, int offset) {
        boolean isScheduled;
        Iternity iternity = new Iternity();
        OsmTrack track = new OsmTrack();
        ScheduledTrip current = trip;
        ScheduledLine lastLine = new ScheduledLine();
        ScheduledLine dummyLine = new ScheduledLine();
        ArrayList<ScheduledTrip> list = new ArrayList<ScheduledTrip>();
        int distance = 0;
        long departure = 0L;
        ScheduledTrip itrip = null;
        String profile = this.extractProfile(this.rc.localFunction);
        SimpleDateFormat df = new SimpleDateFormat("dd.MM HH:mm");
        OsmNodeP nextNode = null;
        while (current != null) {
            ScheduledLine line;
            boolean isConnection;
            departure = current.departure;
            OsmNodeP node = current.getTargetNode();
            OsmPathElement pe = OsmPathElement.create(node.ilon, node.ilat, node.selev, null, false);
            track.addNode(pe);
            if (nextNode != null) {
                distance += node.calcDistance(nextNode);
            }
            isScheduled = current.link instanceof ScheduledLink;
            boolean bl = isConnection = current.link.descriptionBitmap == null && !isScheduled;
            ScheduledLine scheduledLine = isScheduled ? ((ScheduledLink)current.link).line : (line = isConnection ? dummyLine : null);
            if (line != lastLine && !isConnection) {
                itrip = new ScheduledTrip();
                itrip.departure = current.departure;
                itrip.arrival = current.arrival;
                itrip.originNode = current.originNode;
                itrip.link = current.link;
                if (isScheduled && list.size() > 0) {
                    ((ScheduledTrip)list.get((int)(list.size() - 1))).originNode = current.getTargetNode();
                }
                list.add(itrip);
            } else if (itrip != null && !isConnection) {
                itrip.departure = current.departure;
                itrip.originNode = current.originNode;
            }
            lastLine = line;
            current = current.origin;
            nextNode = node;
        }
        track.distance = distance;
        track.cost = trip.cost;
        for (int i = list.size() - 1; i >= 0; --i) {
            current = (ScheduledTrip)list.get(i);
            String lineName = profile;
            isScheduled = current.link instanceof ScheduledLink;
            if (isScheduled) {
                lineName = ((ScheduledLink)current.link).line.name;
            }
            String stationName = "*position*";
            if (current.originNode instanceof StationNode) {
                stationName = ((StationNode)current.originNode).name;
            }
            String nextStationName = "*position*";
            if (i > 0 && ((ScheduledTrip)list.get((int)(i - 1))).originNode instanceof StationNode) {
                nextStationName = ((StationNode)((ScheduledTrip)list.get((int)(i - 1))).originNode).name;
            }
            if (i == 0 && current.link.targetNode instanceof StationNode) {
                nextStationName = ((StationNode)current.link.targetNode).name;
            }
            Date d0 = new Date(this.time0 + 60000L * (long)offset + current.departure);
            Date d1 = new Date(this.time0 + 60000L * (long)offset + current.arrival);
            if (iternity.details.size() > 0) {
                iternity.details.add("");
            }
            iternity.details.add("depart: " + df.format(d0) + " " + stationName);
            iternity.details.add("                    --- " + lineName + " ---");
            iternity.details.add("arrive: " + df.format(d1) + " " + nextStationName);
            if (iternity.lines.contains(lineName)) continue;
            iternity.lines.add(lineName);
        }
        iternity.track = track;
        iternity.arrivaltime = this.time0 + 60000L * (long)offset + trip.arrival;
        iternity.departtime = this.time0 + 60000L * (long)offset + departure;
        return iternity;
    }

    private String extractProfile(String s) {
        int idx = s.lastIndexOf(47);
        if (idx >= 0) {
            s = s.substring(idx + 1);
        }
        if ((idx = s.indexOf(46)) >= 0) {
            s = s.substring(0, idx);
        }
        return s;
    }
}

