/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.MapCreatorBase;
import btools.mapsplitter.NodeData;
import btools.util.LongList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class WayData
extends MapCreatorBase {
    public long wid;
    public LongList nodes;
    public int startNodeIdx;
    private int minx;
    private int miny;
    private int maxx;
    private int maxy;
    public int zoom = -1;
    public int nativeIndex;

    public void calcBBox(List<NodeData> nodeList) {
        int nn = this.nodes.size();
        for (int i = 0; i < nn; ++i) {
            NodeData n = nodeList.get((int)this.nodes.get(i));
            if (i == 0) {
                this.minx = this.maxx = n.ilon;
                this.miny = this.maxy = n.ilat;
                continue;
            }
            if (n.ilon < this.minx) {
                this.minx = n.ilon;
            }
            if (n.ilon > this.maxx) {
                this.maxx = n.ilon;
            }
            if (n.ilat < this.miny) {
                this.miny = n.ilat;
            }
            if (n.ilat <= this.maxy) continue;
            this.maxy = n.ilat;
        }
    }

    public boolean inBBox(int z, int x, int y) {
        int shift = 28 - z;
        int x0 = x << shift;
        int x1 = x + 1 << shift;
        int y0 = y << shift;
        int y1 = y + 1 << shift;
        boolean outofbox = x1 < this.minx || x0 >= this.maxx || y1 < this.miny || y0 >= this.maxy;
        return !outofbox;
    }

    public WayData(long id) {
        this.wid = id;
        this.nodes = new LongList(16);
    }

    public WayData(long id, LongList nodes) {
        this.wid = id;
        this.nodes = nodes;
    }

    public WayData(DataInputStream di) throws Exception {
        long nid;
        String key;
        this.zoom = di.readInt();
        this.nativeIndex = di.readInt();
        this.nodes = new LongList(16);
        this.wid = WayData.readId(di);
        while ((key = di.readUTF()).length() != 0) {
            String value = di.readUTF();
            this.putTag(key, value);
        }
        while ((nid = WayData.readId(di)) != -1L) {
            this.nodes.add(nid);
        }
    }

    public void writeTo(DataOutputStream dos) throws Exception {
        dos.writeInt(this.zoom);
        dos.writeInt(this.nativeIndex);
        WayData.writeId(dos, this.wid);
        if (this.getTagsOrNull() != null) {
            for (Map.Entry<String, String> me : this.getTagsOrNull().entrySet()) {
                if (me.getKey().length() <= 0) continue;
                dos.writeUTF(me.getKey());
                dos.writeUTF(me.getValue());
            }
        }
        dos.writeUTF("");
        int size = this.nodes.size();
        for (int i = 0; i < size; ++i) {
            WayData.writeId(dos, this.nodes.get(i));
        }
        WayData.writeId(dos, -1L);
    }

    public static void sortByStartNode(List<WayData> ways) {
        Collections.sort(ways, new Comparator<WayData>(){

            @Override
            public int compare(WayData w1, WayData w2) {
                long d = w1.startNodeIdx - w2.startNodeIdx;
                if (d == 0L) {
                    d = w1.wid - w2.wid;
                }
                return d == 0L ? 0 : (d < 0L ? -1 : 1);
            }
        });
    }

    public boolean equals(Object o) {
        if (o instanceof WayData) {
            WayData w = (WayData)o;
            return w.wid == this.wid;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.wid >> 32 ^ this.wid);
    }
}

