/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.MapCreatorBase;
import btools.mapsplitter.NodeData;
import btools.mapsplitter.OsmParser2;
import btools.mapsplitter.RelationData;
import btools.mapsplitter.WayData;
import btools.util.DiffCoderDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class OsmSplitter
extends MapCreatorBase {
    private long recordCnt;
    private long nodesParsed;
    private long waysParsed;
    private long relsParsed;
    private long changesetsParsed;
    private DataOutputStream wayDos;
    private DataOutputStream relDos;
    private DiffCoderDataOutputStream nodeDos;

    public static void main(String[] args) throws Exception {
        System.out.println("*** OsmSplitter : transform an osm map to zoom 0 tiles");
        if (args.length != 2) {
            System.out.println("usage : java OsmSplitter <tile-dir> <inputfile> ");
            return;
        }
        new OsmSplitter().process(new File(args[0]), new File(args[1]));
    }

    public void process(File outTileDir, File mapFile) throws Exception {
        if (!outTileDir.isDirectory()) {
            throw new RuntimeException("out tile directory " + outTileDir + " does not exist");
        }
        File z0 = new File(outTileDir, "0");
        z0.mkdirs();
        File ways = new File(z0, "0_0.wtl");
        File nodes = new File(z0, "0_0.ntl");
        File rels = new File(z0, "0_0.rtl");
        this.wayDos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ways)));
        this.relDos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(rels)));
        this.nodeDos = new DiffCoderDataOutputStream(new BufferedOutputStream(new FileOutputStream(nodes)));
        long t0 = System.currentTimeMillis();
        new OsmParser2().readMap(mapFile, this, this, this);
        long t1 = System.currentTimeMillis();
        System.out.println("parsing time (ms) =" + (t1 - t0));
        this.wayDos.close();
        this.nodeDos.close();
        System.out.println(this.statsLine());
    }

    private void checkStats() {
        if (++this.recordCnt % 100000L == 0L) {
            System.out.println(this.statsLine());
        }
    }

    private String statsLine() {
        return "records read: " + this.recordCnt + " nodes=" + this.nodesParsed + " ways=" + this.waysParsed + " rels=" + this.relsParsed + " changesets=" + this.changesetsParsed;
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
        ++this.nodesParsed;
        this.checkStats();
        n.writeTo(this.nodeDos);
    }

    @Override
    public void nextWay(WayData w) throws Exception {
        ++this.waysParsed;
        this.checkStats();
        w.writeTo(this.wayDos);
    }

    @Override
    public void nextRelation(RelationData r) throws Exception {
        ++this.relsParsed;
        this.checkStats();
        r.writeTo(this.relDos);
    }
}

