/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.MapCreatorBase;
import btools.mapsplitter.NodeData;
import btools.mapsplitter.NodeListener;
import btools.util.DiffCoderDataInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;

public class NodeIterator
extends MapCreatorBase {
    private NodeListener listener;

    public NodeIterator(NodeListener nodeListener) {
        this.listener = nodeListener;
    }

    public void processDir(File indir, String inSuffix) throws Exception {
        if (!indir.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + indir);
        }
        File[] af = NodeIterator.sortBySizeAsc(indir.listFiles());
        for (int i = 0; i < af.length; ++i) {
            File nodefile = af[i];
            if (!nodefile.getName().endsWith(inSuffix)) continue;
            this.processFile(nodefile);
        }
    }

    public void processFile(File nodefile) throws Exception {
        System.out.println("*** NodeIterator reading: " + nodefile);
        this.listener.nodeFileStart(nodefile);
        DiffCoderDataInputStream di = new DiffCoderDataInputStream(new BufferedInputStream(new FileInputStream(nodefile)));
        try {
            while (true) {
                NodeData n = new NodeData(di);
                this.listener.nextNode(n);
            }
        }
        catch (EOFException eof) {
            di.close();
            this.listener.nodeFileEnd(nodefile);
            return;
        }
    }
}

