/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.MapCreatorBase;
import btools.util.DiffCoderDataInputStream;
import btools.util.DiffCoderDataOutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class NodeData
extends MapCreatorBase {
    public long nid;
    public int ilon;
    public int ilat;
    public byte[] description;
    public short selev = Short.MIN_VALUE;
    public long gid;
    public int zoom = -1;
    public int nativeIndex;
    public transient int localeIndex;
    public transient boolean used;

    public NodeData(long id, double lon, double lat) {
        this.nid = id;
        double y = NodeData.gudermannianInv(lat);
        this.ilat = (int)((1.0 - y / Math.PI) * 1.34217728E8 + 0.5);
        this.ilon = (int)((lon / 180.0 + 1.0) * 1.34217728E8 + 0.5);
    }

    public NodeData(long id, int ilon, int ilat) {
        this.nid = id;
        this.ilat = ilat;
        this.ilon = ilon;
    }

    public boolean inBBox(int z, int x, int y) {
        int shift = 28 - z;
        int x0 = x << shift;
        int x1 = x + 1 << shift;
        int y0 = y << shift;
        int y1 = y + 1 << shift;
        boolean outofbox = x1 < this.ilon || x0 >= this.ilon || y1 < this.ilat || y0 >= this.ilat;
        return !outofbox;
    }

    public static double gudermannianInv(double latitude) {
        double sign = latitude < 0.0 ? -1.0 : 1.0;
        double sin = Math.sin(latitude * (Math.PI / 180) * sign);
        return sign * (Math.log((1.0 + sin) / (1.0 - sin)) / 2.0);
    }

    public static double gudermannian(double y) {
        return Math.atan(Math.sinh(y)) * 57.29577951308232;
    }

    public double getLon() {
        return ((double)this.ilon / 1.34217728E8 - 1.0) * 180.0;
    }

    public double getLat() {
        double y = (1.0 - (double)this.ilat / 1.34217728E8) * Math.PI;
        return NodeData.gudermannian(y);
    }

    public void calcGeoId() {
        if (this.zoom < 0) {
            throw new IllegalArgumentException("no zoom level yet");
        }
        this.gid = 0L;
        for (long bm = 1L << 27 - this.zoom; bm > 0L; bm >>= 1) {
            this.gid <<= 2;
            if (((long)this.ilon & bm) != 0L) {
                this.gid |= 1L;
            }
            if (((long)this.ilat & bm) == 0L) continue;
            this.gid |= 2L;
        }
    }

    public static void sortByGeoId(List<NodeData> nodes) {
        Collections.sort(nodes, new Comparator<NodeData>(){

            @Override
            public int compare(NodeData n1, NodeData n2) {
                long d = n1.gid - n2.gid;
                if (d == 0L) {
                    d = n1.nid - n2.nid;
                }
                return d == 0L ? 0 : (d < 0L ? -1 : 1);
            }
        });
    }

    public NodeData(DiffCoderDataInputStream dis) throws Exception {
        String key;
        this.zoom = dis.readInt();
        this.nativeIndex = dis.readInt();
        this.nid = dis.readDiffed(0);
        this.ilon = (int)dis.readDiffed(1);
        this.ilat = (int)dis.readDiffed(2);
        while ((key = dis.readUTF()).length() != 0) {
            String value = dis.readUTF();
            this.putTag(key, value);
        }
    }

    public void writeTo(DiffCoderDataOutputStream dos) throws Exception {
        dos.writeInt(this.zoom);
        dos.writeInt(this.nativeIndex);
        dos.writeDiffed(this.nid, 0);
        dos.writeDiffed(this.ilon, 1);
        dos.writeDiffed(this.ilat, 2);
        if (this.getTagsOrNull() != null) {
            for (Map.Entry<String, String> me : this.getTagsOrNull().entrySet()) {
                if (me.getKey().length() <= 0) continue;
                dos.writeUTF(me.getKey());
                dos.writeUTF(me.getValue());
            }
        }
        dos.writeUTF("");
    }

    private int mercatorLon(long x, long z) {
        return (int)(360000000L * x >> (int)z);
    }

    private int mercatorLat(long y, long z) {
        double n = Math.PI - Math.PI * 2 * (double)y / (double)(1L << (int)z);
        double d = Math.toDegrees(Math.atan(Math.sinh(n)));
        return (int)((d + 90.0) * 1000000.0 + 0.5);
    }

    public boolean equals(Object o) {
        if (o instanceof NodeData) {
            NodeData n = (NodeData)o;
            return n.nid == this.nid;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.nid >> 32 ^ this.nid);
    }
}

