/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.BitWriteBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;

public abstract class HuffmanTreeEncoder<V> {
    private HashMap<TreeNode, TreeNode> identityMap = new HashMap();
    protected BitWriteBuffer bwb;
    protected int pass;
    private TreeNode freq1;

    public void encode(V data) {
        if (this.pass == 1) {
            return;
        }
        TreeNode probe = new TreeNode();
        probe.data = data;
        TreeNode tn = this.identityMap.get(probe);
        if (this.pass == 3) {
            if (tn.frequency == 1) {
                this.bwb.encodeBounded(this.freq1.range - 1, this.freq1.code);
                this.encodeItem(data);
            } else {
                this.bwb.encodeBounded(tn.range - 1, tn.code);
            }
        } else if (this.pass == 2) {
            if (tn == null) {
                tn = probe;
                this.identityMap.put(tn, tn);
            }
            ++tn.frequency;
        }
    }

    public void encodeDictionary(BitWriteBuffer bwb) {
        this.bwb = bwb;
        if (++this.pass == 3) {
            this.freq1 = new TreeNode();
            PriorityQueue<TreeNode> queue = new PriorityQueue<TreeNode>(2 * this.identityMap.size(), new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode tn1, TreeNode tn2) {
                    if (tn1.frequency < tn2.frequency) {
                        return -1;
                    }
                    if (tn1.frequency > tn2.frequency) {
                        return 1;
                    }
                    return 0;
                }
            });
            queue.add(this.freq1);
            while (queue.size() > 1) {
                TreeNode node = new TreeNode();
                node.child1 = queue.poll();
                node.child2 = queue.poll();
                node.frequency = node.child1.frequency + node.child2.frequency;
                queue.add(node);
            }
            TreeNode root = queue.poll();
            root.encode(1, 0);
        }
    }

    protected abstract void encodeItem(V var1);

    protected abstract boolean itemEquals(V var1, V var2);

    protected abstract int itemHashCode(V var1);

    public final class TreeNode {
        public V data;
        public int frequency;
        public int code;
        public int range;
        public TreeNode child1;
        public TreeNode child2;

        public void encode(int range, int code) {
            this.range = range;
            this.code = code;
            boolean isNode = this.child1 != null;
            HuffmanTreeEncoder.this.bwb.encodeBit(isNode);
            if (isNode) {
                this.child1.encode(range << 1, code);
                this.child2.encode(range << 1, code + range);
            } else {
                HuffmanTreeEncoder.this.bwb.encodeBit(this.data == null);
                if (this.data != null) {
                    HuffmanTreeEncoder.this.encodeItem(this.data);
                }
            }
        }

        public boolean equals(Object o) {
            return HuffmanTreeEncoder.this.itemEquals(((TreeNode)o).data, this.data);
        }

        public int hashCode() {
            return HuffmanTreeEncoder.this.itemHashCode(this.data);
        }
    }
}

