/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import java.util.TreeMap;

public final class BitWriteBuffer {
    private static TreeMap<String, long[]> statsPerName;
    private long lastbitpos = 0L;
    private byte[] ab;
    private int idxMax;
    private int idx = -1;
    private int bm = 256;
    private int b;

    public BitWriteBuffer(byte[] ab) {
        this.ab = ab;
        this.idxMax = ab.length - 1;
    }

    public void encodeInt(int value) {
        int range = 0;
        while (value > range) {
            this.encodeBit(false);
            value -= range + 1;
            range = 2 * range + 1;
        }
        this.encodeBit(true);
        this.encodeBounded(range, value);
    }

    public void encodeLong(long n) {
        int maxbit = 0;
        for (long nn = n + 1L; nn > 1L; nn >>= 1) {
            ++maxbit;
        }
        this.encodeInt(maxbit);
        long range = 1 << maxbit;
        this.encodeBounded(range - 1L, n + 1L - range);
    }

    public void encodeBit(boolean value) {
        if (this.bm == 256) {
            this.bm = 1;
            this.ab[++this.idx] = 0;
        }
        if (value) {
            int n = this.idx;
            this.ab[n] = (byte)(this.ab[n] | this.bm);
        }
        this.bm <<= 1;
    }

    public void encodeBounded(long max, long value) {
        for (long im = 1L; im <= max; im <<= 1) {
            if (this.bm == 256) {
                this.bm = 1;
                this.ab[++this.idx] = 0;
            }
            if ((value & im) != 0L) {
                int n = this.idx;
                this.ab[n] = (byte)(this.ab[n] | this.bm);
                max -= im;
            }
            this.bm <<= 1;
        }
    }

    public int getEncodedLength() {
        return this.idx + 1;
    }

    public long getWritingBitPosition() {
        long bitpos = this.idx << 3;
        for (int m = this.bm; m > 1; m >>= 1) {
            ++bitpos;
        }
        return bitpos;
    }

    public void encodeSortedArray(long[] values) {
        int size = values.length;
        this.encodeInt(size);
        if (size == 0) {
            return;
        }
        int nbits = 0;
        for (long maxValue = values[size - 1]; maxValue > 0L; maxValue >>= 1) {
            ++nbits;
        }
        if (nbits > 57) {
            throw new IllegalArgumentException("encodeSortedArray accepts 57-bit numbers at max");
        }
        this.encodeInt(nbits);
        this.encodeSortedArray(values, 0, size, 1L << nbits >> 1, 0L);
    }

    private void encodeSortedArray(long[] values, int offset, int subsize, long nextbit, long mask) {
        int i;
        if (subsize == 1) {
            for (long bit = 1L; bit <= nextbit; bit <<= 1) {
                this.encodeBit((values[offset] & bit) != 0L);
            }
            return;
        }
        if (nextbit == 0L) {
            return;
        }
        long data = mask & values[offset];
        mask |= nextbit;
        int end = subsize + offset;
        for (i = offset; i < end && (values[i] & mask) == data; ++i) {
        }
        int size1 = i - offset;
        int size2 = subsize - size1;
        this.encodeBounded(subsize, size2);
        if (size1 > 0) {
            this.encodeSortedArray(values, offset, size1, nextbit >> 1, mask);
        }
        if (size2 > 0) {
            this.encodeSortedArray(values, i, size2, nextbit >> 1, mask);
        }
    }

    public void assignBits(String name) {
        long[] stats;
        long bitpos = this.getWritingBitPosition();
        if (statsPerName == null) {
            statsPerName = new TreeMap();
        }
        if ((stats = statsPerName.get(name)) == null) {
            stats = new long[2];
            statsPerName.put(name, stats);
        }
        stats[0] = stats[0] + (bitpos - this.lastbitpos);
        stats[1] = stats[1] + 1L;
        this.lastbitpos = bitpos;
    }

    public static String getBitReport() {
        if (statsPerName == null) {
            return "<empty bit report>";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : statsPerName.keySet()) {
            long[] stats = statsPerName.get(name);
            sb.append(name + " count=" + stats[1] + " bits=" + stats[0] + "\n");
        }
        statsPerName = null;
        return sb.toString();
    }
}

