/*
 * Decompiled with CFR 0.152.
 */
package btools.mapdecoder;

import btools.mapdecoder.BitReadBuffer;
import btools.mapdecoder.HuffmannTreeDecoder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class TagValueDecoder {
    private int nextStringStart = 0;
    private byte[] textHeader;
    private ArrayList<String> stringList;
    private ArrayList<Tag> taglist;
    private int roleIdx;

    private String decodeString(BitReadBuffer brb) {
        boolean newIdx = brb.decodeBit();
        if (newIdx) {
            int slen = brb.decodeInt();
            try {
                String s = new String(this.textHeader, this.nextStringStart, slen, "UTF8");
                this.nextStringStart += slen;
                this.stringList.add(s);
                return s;
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        }
        int idx = (int)brb.decodeBounded(this.stringList.size() - 1);
        return this.stringList.get(idx);
    }

    public TagValueDecoder(BitReadBuffer brb, byte[] textHeader) {
        this.textHeader = textHeader;
        this.stringList = new ArrayList();
        int ntags = brb.decodeInt();
        this.taglist = new ArrayList();
        for (int i = 0; i < ntags; ++i) {
            String tagName = this.decodeString(brb);
            this.taglist.add(new Tag(brb, tagName));
            if (!"role".equals(tagName)) continue;
            this.roleIdx = i;
        }
    }

    public String getTagName(int idx) {
        return this.taglist.get((int)idx).name;
    }

    public String decodeValue(int tagIdx) {
        return (String)this.taglist.get(tagIdx).decode();
    }

    public String decodeRole() {
        return (String)this.taglist.get(this.roleIdx).decode();
    }

    private class Tag
    extends HuffmannTreeDecoder<String> {
        String name;

        Tag(BitReadBuffer brb, String tagName) {
            super(brb);
            this.name = tagName;
        }

        @Override
        protected String decodeItem() {
            return TagValueDecoder.this.decodeString(this.brb);
        }
    }
}

