/*
 * Decompiled with CFR 0.152.
 */
package btools.mapdecoder;

import btools.mapdecoder.OsmObject;

public class OsmNode
extends OsmObject {
    public int ilon;
    public int ilat;

    public boolean inBBox(int z, int x, int y) {
        int shift = 28 - z;
        int x0 = x << shift;
        int x1 = x + 1 << shift;
        int y0 = y << shift;
        int y1 = y + 1 << shift;
        boolean outofbox = x1 < this.ilon || x0 >= this.ilon || y1 < this.ilat || y0 >= this.ilat;
        return !outofbox;
    }

    public static double gudermannian(double y) {
        return Math.atan(Math.sinh(y)) * 57.29577951308232;
    }

    public double getLon() {
        return ((double)this.ilon / 1.34217728E8 - 1.0) * 180.0;
    }

    public double getLat() {
        double y = (1.0 - (double)this.ilat / 1.34217728E8) * Math.PI;
        return OsmNode.gudermannian(y);
    }
}

