/*
 * Decompiled with CFR 0.152.
 */
package btools.mapdecoder;

import btools.mapdecoder.BitReadBuffer;
import btools.mapdecoder.OsmNode;
import btools.mapdecoder.OsmTile;
import btools.mapdecoder.OsmWay;

public class LocaleIndexMapping {
    private int[] refZoomDelta;
    private int[] refNativeIndex;
    private OsmTile[] tileForZoomDelta;

    public LocaleIndexMapping(OsmTile tile, BitReadBuffer brb) throws Exception {
        int localeNodeCount = brb.decodeInt();
        this.refZoomDelta = new int[localeNodeCount];
        this.refNativeIndex = new int[localeNodeCount];
        this.tileForZoomDelta = new OsmTile[tile.zoom + 1];
        OsmTile t = tile;
        while (t != null) {
            this.tileForZoomDelta[tile.zoom - t.zoom] = t;
            t = t.parent;
        }
        for (int zoomDelta = tile.zoom; zoomDelta > 0; --zoomDelta) {
            long[] localeIndexes = brb.decodeSortedArray();
            long[] nativeIndexes = brb.decodeSortedArray();
            for (int i = 0; i < localeIndexes.length; ++i) {
                int idx = (int)localeIndexes[i];
                this.refZoomDelta[idx] = zoomDelta;
                this.refNativeIndex[idx] = (int)nativeIndexes[i];
            }
        }
        int localeIdx = 0;
        int nodecount = tile.nodePositions.length;
        int i = 0;
        while (i < nodecount) {
            while (this.refZoomDelta[localeIdx] != 0) {
                ++localeIdx;
            }
            this.refNativeIndex[localeIdx++] = i++;
        }
    }

    public OsmNode nodeForLocaleIndex(int localeIndex) {
        int zoomDelta = this.refZoomDelta[localeIndex];
        int nativeIndex = this.refNativeIndex[localeIndex];
        return this.tileForZoomDelta[zoomDelta].nodes.get(nativeIndex);
    }

    public OsmWay getWay(int zoomDelta, int nativeIndex) {
        return this.tileForZoomDelta[zoomDelta].ways.get(nativeIndex);
    }
}

