/*
 * Decompiled with CFR 0.152.
 */
package btools.mapdecoder;

import btools.mapdecoder.BitReadBuffer;

public abstract class HuffmannTreeDecoder<V> {
    private Object tree;
    protected BitReadBuffer brb;

    protected HuffmannTreeDecoder(BitReadBuffer brb) {
        this.brb = brb;
        this.tree = this.decodeTree();
    }

    public V decode() {
        Object node = this.tree;
        while (node instanceof TreeNode) {
            TreeNode tn = (TreeNode)node;
            node = this.brb.decodeBit() ? tn.child2 : tn.child1;
        }
        if (node == null) {
            return this.decodeItem();
        }
        return (V)node;
    }

    protected Object decodeTree() {
        boolean isNode = this.brb.decodeBit();
        if (isNode) {
            TreeNode node = new TreeNode();
            node.child1 = this.decodeTree();
            node.child2 = this.decodeTree();
            return node;
        }
        boolean isInlinePrefix = this.brb.decodeBit();
        if (isInlinePrefix) {
            return null;
        }
        return this.decodeItem();
    }

    protected abstract V decodeItem();

    private static final class TreeNode {
        public Object child1;
        public Object child2;

        private TreeNode() {
        }
    }
}

