/*
 * Decompiled with CFR 0.152.
 */
package btools.mapdecoder;

import btools.mapdecoder.BitReadBuffer;
import btools.mapdecoder.HuffmannTreeDecoder;

public final class CharDecoder
extends HuffmannTreeDecoder<Character> {
    private long[] alphabet;
    private int range;
    private char[] buffer = new char[64];

    public CharDecoder(BitReadBuffer brb) {
        super(brb);
    }

    @Override
    protected Object decodeTree() {
        this.alphabet = this.brb.decodeSortedArray();
        this.range = this.alphabet.length - 1;
        System.out.println("decoded alphabet of length " + this.alphabet.length + " idx3 = " + this.alphabet[3]);
        return super.decodeTree();
    }

    @Override
    protected Character decodeItem() {
        int idx = (int)this.brb.decodeBounded(this.range);
        long lc = this.alphabet[idx];
        System.out.println("decoded item: c=" + (char)lc + " idx=" + idx);
        return Character.valueOf((char)lc);
    }

    public String decodeString() {
        int n = this.brb.decodeInt();
        char[] b = n <= this.buffer.length ? this.buffer : new char[n];
        for (int i = 0; i < n; ++i) {
            b[i] = ((Character)this.decode()).charValue();
        }
        return new String(b, 0, n);
    }
}

