/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class DiffCoderDataOutputStream
extends DataOutputStream {
    private long[] lastValues = new long[10];

    public DiffCoderDataOutputStream(OutputStream os) {
        super(os);
    }

    public void writeDiffed(long v, int idx) throws IOException {
        long d = v - this.lastValues[idx];
        this.lastValues[idx] = v;
        this.writeSigned(d);
    }

    public void writeSigned(long v) throws IOException {
        this.writeUnsigned(v < 0L ? -v << 1 | 1L : v << 1);
    }

    public void writeUnsigned(long v) throws IOException {
        do {
            long i7 = v & 0x7FL;
            if ((v >>= 7) != 0L) {
                i7 |= 0x80L;
            }
            this.writeByte((byte)(i7 & 0xFFL));
        } while (v != 0L);
    }
}

