/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.MicroCache;
import btools.codec.MicroCache2;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNodesMap;
import btools.mapaccess.OsmPos;
import btools.mapaccess.TurnRestriction;
import btools.util.ByteArrayUnifier;
import btools.util.IByteArrayUnifier;

public class OsmNode
extends OsmLink
implements OsmPos {
    public int ilat;
    public int ilon;
    public short selev;
    public byte[] nodeDescription;
    public TurnRestriction firstRestriction;
    public OsmLink firstlink = null;

    public OsmNode() {
    }

    public OsmNode(int ilon, int ilat) {
        this.ilon = ilon;
        this.ilat = ilat;
    }

    public OsmNode(long id) {
        this.ilon = (int)(id >> 32);
        this.ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public final int getILat() {
        return this.ilat;
    }

    @Override
    public final int getILon() {
        return this.ilon;
    }

    @Override
    public final short getSElev() {
        return this.selev;
    }

    @Override
    public final double getElev() {
        return (double)this.selev / 4.0;
    }

    private void addLink(OsmLink link, boolean isReverse, OsmNode tn) {
        if (isReverse) {
            link.n1 = tn;
            link.n2 = this;
            link.next = tn.firstlink;
            link.previous = this.firstlink;
            tn.firstlink = link;
            this.firstlink = link;
        } else {
            link.n1 = this;
            link.n2 = tn;
            link.next = this.firstlink;
            link.previous = tn.firstlink;
            tn.firstlink = link;
            this.firstlink = link;
        }
    }

    @Override
    public final int calcDistance(OsmPos p) {
        double l = (double)(this.ilat - 90000000) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        double coslat = 1.0 - l2 + l4 / 6.0;
        double dlat = (double)(this.ilat - p.getILat()) / 1000000.0;
        double dlon = (double)(this.ilon - p.getILon()) / 1000000.0 * coslat;
        double d = Math.sqrt(dlat * dlat + dlon * dlon) * 111308.90052356021;
        return (int)(d + 1.0);
    }

    public String toString() {
        return "" + this.getIdFromPos();
    }

    public final void parseNodeBody(MicroCache mc, OsmNodesMap hollowNodes, IByteArrayUnifier expCtxWay) {
        if (!(mc instanceof MicroCache2)) {
            throw new IllegalArgumentException("unknown cache version: " + mc.getClass());
        }
        this.parseNodeBody2((MicroCache2)mc, hollowNodes, expCtxWay);
    }

    public final void parseNodeBody2(MicroCache2 mc, OsmNodesMap hollowNodes, IByteArrayUnifier expCtxWay) {
        ByteArrayUnifier abUnifier = hollowNodes.getByteArrayUnifier();
        while (mc.readBoolean()) {
            TurnRestriction tr = new TurnRestriction();
            tr.exceptions = mc.readShort();
            tr.isPositive = mc.readBoolean();
            tr.fromLon = mc.readInt();
            tr.fromLat = mc.readInt();
            tr.toLon = mc.readInt();
            tr.toLat = mc.readInt();
            tr.next = this.firstRestriction;
            this.firstRestriction = tr;
        }
        this.selev = mc.readShort();
        int nodeDescSize = mc.readVarLengthUnsigned();
        this.nodeDescription = nodeDescSize == 0 ? null : mc.readUnified(nodeDescSize, abUnifier);
        OsmLink link0 = this.firstlink;
        while (mc.hasMoreData()) {
            int endPointer = mc.getEndPointer();
            int linklon = this.ilon + mc.readVarLengthSigned();
            int linklat = this.ilat + mc.readVarLengthSigned();
            int sizecode = mc.readVarLengthUnsigned();
            boolean isReverse = (sizecode & 1) != 0;
            byte[] description = null;
            int descSize = sizecode >> 1;
            if (descSize > 0) {
                description = mc.readUnified(descSize, expCtxWay);
            }
            byte[] geometry = mc.readDataUntil(endPointer);
            if (linklon == this.ilon && linklat == this.ilat) continue;
            OsmNode tn = null;
            OsmLink link = null;
            for (OsmLink l = link0; l != null; l = l.getNext(this)) {
                OsmNode t = l.getTarget(this);
                if (t.ilon != linklon || t.ilat != linklat) continue;
                tn = t;
                if (!isReverse && (l.descriptionBitmap != null || l.isReverse(this))) continue;
                link = l;
                break;
            }
            if (tn == null && (tn = hollowNodes.get(linklon, linklat)) == null) {
                tn = new OsmNode(linklon, linklat);
                tn.setHollow();
                hollowNodes.put(tn);
                link = tn;
                this.addLink(link, isReverse, tn);
            }
            if (link == null) {
                link = new OsmLink();
                this.addLink(link, isReverse, tn);
            }
            if (isReverse) continue;
            link.descriptionBitmap = description;
            link.geometry = geometry;
        }
        hollowNodes.remove(this);
    }

    public final boolean isHollow() {
        return this.selev == -12345;
    }

    public final void setHollow() {
        this.selev = (short)-12345;
    }

    @Override
    public final long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public final void unlinkLink(OsmLink link) {
        OsmLink n = link.clear(this);
        if (link == this.firstlink) {
            this.firstlink = n;
            return;
        }
        OsmLink l = this.firstlink;
        while (l != null) {
            OsmLink nl;
            if (l.n1 != this && l.n1 != null) {
                nl = l.previous;
                if (nl == link) {
                    l.previous = n;
                    return;
                }
                l = nl;
                continue;
            }
            nl = l.next;
            if (nl == link) {
                l.next = n;
                return;
            }
            l = nl;
        }
    }

    public final boolean equals(Object o) {
        if (o instanceof OsmNode) {
            OsmNode n = (OsmNode)o;
            return n.ilon == this.ilon && n.ilat == this.ilat;
        }
        return false;
    }

    public final int hashCode() {
        return this.ilon + this.ilat;
    }
}

