/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import btools.expressions.BExpressionContextWay;
import btools.memrouter.GraphLoader;
import btools.memrouter.OsmLinkP;
import btools.memrouter.OsmNodeP;
import btools.memrouter.ScheduledLine;
import btools.memrouter.ScheduledLink;
import btools.memrouter.StationNode;
import btools.memrouter.TrainSchedule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

final class ScheduleParser {
    ScheduleParser() {
    }

    public static Map<String, StationNode> parseTrainTable(File[] files, GraphLoader graph, BExpressionContextWay expctxWay) {
        ScheduledLine currentLine = null;
        StationNode lastStationInLine = null;
        boolean readingLocations = false;
        HashMap<String, StationNode> stationMap = new HashMap<String, StationNode>();
        for (File file : files) {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    if (line.startsWith("-- locations")) {
                        readingLocations = true;
                        continue;
                    }
                    if (line.startsWith("-- trainline")) {
                        readingLocations = false;
                        currentLine = new ScheduledLine();
                        currentLine.name = line.substring("-- trainline".length()).trim();
                        lastStationInLine = null;
                        continue;
                    }
                    if (readingLocations) {
                        StationNode station = new StationNode();
                        StringTokenizer tk = new StringTokenizer(line, " \t");
                        station.name = tk.nextToken();
                        if (stationMap.containsKey(station.name)) {
                            System.out.println("skipping station name already known: " + station.name);
                            continue;
                        }
                        String loc = null;
                        int elev = 0;
                        int nconnections = 0;
                        for (int locIdx = 0; tk.hasMoreTokens() || locIdx == 1; ++locIdx) {
                            if (tk.hasMoreTokens()) {
                                loc = tk.nextToken();
                            }
                            StringTokenizer tloc = new StringTokenizer(loc, ",");
                            int ilat = (int)((Double.parseDouble(tloc.nextToken()) + 90.0) * 1000000.0 + 0.5);
                            int ilon = (int)((Double.parseDouble(tloc.nextToken()) + 180.0) * 1000000.0 + 0.5);
                            if (locIdx == 0) {
                                station.ilat = ilat;
                                station.ilon = ilon;
                                continue;
                            }
                            OsmNodeP pos = new OsmNodeP();
                            pos.ilat = ilat;
                            pos.ilon = ilon;
                            OsmNodeP node = graph.matchNodeForPosition(pos, expctxWay, false);
                            if (node == null) continue;
                            elev += node.selev;
                            ++nconnections;
                            OsmLinkP link = new OsmLinkP(station, node);
                            link.descriptionBitmap = null;
                            station.addLink(link);
                            node.addLink(link);
                            int distance = station.calcDistance(node);
                            System.out.println("matched connection for station " + station.name + " at " + distance + " meter");
                        }
                        if (nconnections > 0) {
                            station.selev = (short)(elev / nconnections);
                        }
                        stationMap.put(station.name, station);
                        continue;
                    }
                    if (currentLine == null) continue;
                    int idx = line.indexOf(32);
                    String name = line.substring(0, idx);
                    StationNode nextStationInLine = (StationNode)stationMap.get(name);
                    if (nextStationInLine == null) {
                        throw new IllegalArgumentException("unknown station: " + name);
                    }
                    String value = line.substring(idx).trim();
                    int offsetMinute = 0;
                    if (lastStationInLine == null) {
                        currentLine.schedule = new TrainSchedule(value);
                    } else {
                        if (value.startsWith("+")) {
                            value = value.substring(1);
                        }
                        offsetMinute = Integer.parseInt(value);
                        ScheduledLink link = new ScheduledLink(lastStationInLine, nextStationInLine);
                        link.line = currentLine;
                        link.indexInLine = currentLine.offsetMinutes.size() - 1;
                        lastStationInLine.addLink(link);
                    }
                    currentLine.offsetMinutes.add(offsetMinute);
                    lastStationInLine = nextStationInLine;
                }
                System.out.println("read " + stationMap.size() + " stations");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return stationMap;
    }
}

