/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.SrtmRaster;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SrtmData {
    private SrtmRaster raster = new SrtmRaster();

    public SrtmData(File file) throws Exception {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            while (true) {
                ZipEntry ze;
                if (!(ze = zis.getNextEntry()).getName().endsWith(".asc")) continue;
                this.readFromStream(zis);
                return;
            }
        }
        finally {
            zis.close();
        }
    }

    public SrtmRaster getRaster() {
        return this.raster;
    }

    private String secondToken(String s) {
        StringTokenizer tk = new StringTokenizer(s, " ");
        tk.nextToken();
        return tk.nextToken();
    }

    public void readFromStream(InputStream is) throws Exception {
        int c;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int linenr = 0;
        while (++linenr <= 6) {
            String line = br.readLine();
            if (linenr == 1) {
                this.raster.ncols = Integer.parseInt(this.secondToken(line));
                continue;
            }
            if (linenr == 2) {
                this.raster.nrows = Integer.parseInt(this.secondToken(line));
                continue;
            }
            if (linenr == 3) {
                this.raster.xllcorner = Double.parseDouble(this.secondToken(line));
                continue;
            }
            if (linenr == 4) {
                this.raster.yllcorner = Double.parseDouble(this.secondToken(line));
                continue;
            }
            if (linenr == 5) {
                this.raster.cellsize = Double.parseDouble(this.secondToken(line));
                continue;
            }
            if (linenr != 6) continue;
            this.raster.eval_array = new short[this.raster.ncols * this.raster.nrows];
        }
        int row = 0;
        int col = 0;
        int n = 0;
        boolean negative = false;
        while ((c = br.read()) >= 0) {
            if (c == 32) {
                int val;
                if (negative) {
                    n = -n;
                }
                this.raster.eval_array[row * this.raster.ncols + col] = val = (short)(n < -250 ? Short.MIN_VALUE : (short)(n * 2));
                if (++col == this.raster.ncols) {
                    col = 0;
                    ++row;
                }
                n = 0;
                negative = false;
                continue;
            }
            if (c >= 48 && c <= 57) {
                n = 10 * n + (c - 48);
                continue;
            }
            if (c != 45) continue;
            negative = true;
        }
        br.close();
    }
}

