/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import btools.memrouter.OffsetSet;
import btools.memrouter.OsmLinkP;
import btools.memrouter.ScheduledLine;
import btools.memrouter.StationNode;
import java.util.SortedSet;
import java.util.TreeSet;

public class ScheduledLink
extends OsmLinkP {
    public ScheduledLine line;
    public int indexInLine;
    private SortedSet<Integer> usedTimes;

    public ScheduledLink(StationNode source, StationNode target) {
        super(source, target);
    }

    @Override
    public boolean isConnection() {
        return false;
    }

    @Override
    public boolean isWayLink() {
        return false;
    }

    public String toString() {
        return "ScheduledLink: line=" + this.line.name + " indexInLine=" + this.indexInLine;
    }

    @Override
    protected void initLink() {
        super.initLink();
        this.usedTimes = new TreeSet<Integer>();
    }

    @Override
    public OffsetSet filterAndClose(OffsetSet in, long arrival) {
        OffsetSet filtered = super.filterAndClose(in, arrival);
        if (filtered != null && arrival >= 0L) {
            int minutesArrival = (int)(arrival / 60000L);
            filtered = filtered.filterWithSet(this.usedTimes, minutesArrival);
        }
        return filtered;
    }
}

