/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.DataBuffers;
import btools.codec.MicroCache;
import btools.codec.MicroCache2;
import btools.codec.TagValueValidator;
import btools.codec.WaypointMatcher;
import btools.mapaccess.PhysicalFile;
import btools.util.ByteDataReader;
import btools.util.Crc32;
import java.io.IOException;
import java.io.RandomAccessFile;

final class OsmFile {
    private RandomAccessFile is = null;
    private long fileOffset;
    private int[] posIdx;
    private MicroCache[] microCaches;
    public int lonDegree;
    public int latDegree;
    public String filename;
    private int divisor;
    private int cellsize;
    private int ncaches;
    private int indexsize;

    public OsmFile(PhysicalFile rafile, int lonDegree, int latDegree, DataBuffers dataBuffers) throws Exception {
        this.lonDegree = lonDegree;
        this.latDegree = latDegree;
        int lonMod5 = lonDegree % 5;
        int latMod5 = latDegree % 5;
        int tileIndex = lonMod5 * 5 + latMod5;
        if (rafile != null) {
            int headerCrc;
            this.divisor = rafile.divisor;
            this.cellsize = 1000000 / this.divisor;
            this.ncaches = this.divisor * this.divisor;
            this.indexsize = this.ncaches * 4;
            byte[] iobuffer = dataBuffers.iobuffer;
            this.filename = rafile.fileName;
            long[] index = rafile.fileIndex;
            long l = this.fileOffset = tileIndex > 0 ? index[tileIndex - 1] : 200L;
            if (this.fileOffset == index[tileIndex]) {
                return;
            }
            this.is = rafile.ra;
            this.posIdx = new int[this.ncaches];
            this.microCaches = new MicroCache[this.ncaches];
            this.is.seek(this.fileOffset);
            this.is.readFully(iobuffer, 0, this.indexsize);
            if (rafile.fileHeaderCrcs != null && rafile.fileHeaderCrcs[tileIndex] != (headerCrc = Crc32.crc(iobuffer, 0, this.indexsize))) {
                throw new IOException("sub index checksum error");
            }
            ByteDataReader dis = new ByteDataReader(iobuffer);
            for (int i = 0; i < this.ncaches; ++i) {
                this.posIdx[i] = dis.readInt();
            }
        }
    }

    public boolean hasData() {
        return this.microCaches != null;
    }

    public MicroCache getMicroCache(int ilon, int ilat) {
        int lonIdx = ilon / this.cellsize;
        int latIdx = ilat / this.cellsize;
        int subIdx = (latIdx - this.divisor * this.latDegree) * this.divisor + (lonIdx - this.divisor * this.lonDegree);
        return this.microCaches[subIdx];
    }

    public MicroCache createMicroCache(int ilon, int ilat, DataBuffers dataBuffers, TagValueValidator wayValidator, WaypointMatcher waypointMatcher) throws Exception {
        int lonIdx = ilon / this.cellsize;
        int latIdx = ilat / this.cellsize;
        MicroCache segment = this.createMicroCache(lonIdx, latIdx, dataBuffers, wayValidator, waypointMatcher, true);
        int subIdx = (latIdx - this.divisor * this.latDegree) * this.divisor + (lonIdx - this.divisor * this.lonDegree);
        this.microCaches[subIdx] = segment;
        return segment;
    }

    private int getPosIdx(int idx) {
        return idx == -1 ? this.indexsize : this.posIdx[idx];
    }

    public int getDataInputForSubIdx(int subIdx, byte[] iobuffer) throws Exception {
        int startPos = this.getPosIdx(subIdx - 1);
        int endPos = this.getPosIdx(subIdx);
        int size = endPos - startPos;
        if (size > 0) {
            this.is.seek(this.fileOffset + (long)startPos);
            if (size <= iobuffer.length) {
                this.is.readFully(iobuffer, 0, size);
            }
        }
        return size;
    }

    public MicroCache createMicroCache(int lonIdx, int latIdx, DataBuffers dataBuffers, TagValueValidator wayValidator, WaypointMatcher waypointMatcher, boolean reallyDecode) throws Exception {
        int crcFooter;
        int crcData;
        int subIdx = (latIdx - this.divisor * this.latDegree) * this.divisor + (lonIdx - this.divisor * this.lonDegree);
        byte[] ab = dataBuffers.iobuffer;
        int asize = this.getDataInputForSubIdx(subIdx, ab);
        if (asize == 0) {
            return MicroCache.emptyCache();
        }
        if (asize > ab.length) {
            ab = new byte[asize];
            asize = this.getDataInputForSubIdx(subIdx, ab);
            dataBuffers = new DataBuffers(ab);
        }
        if (((crcData = Crc32.crc(ab, 0, asize - 4)) ^ 2) == (crcFooter = new ByteDataReader(ab, asize - 4).readInt())) {
            return reallyDecode ? new MicroCache2(dataBuffers, lonIdx, latIdx, this.divisor, wayValidator, waypointMatcher) : null;
        }
        throw new IOException("checkum error");
    }

    long setGhostState() {
        long sum = 0L;
        int nc = this.microCaches == null ? 0 : this.microCaches.length;
        for (int i = 0; i < nc; ++i) {
            MicroCache mc = this.microCaches[i];
            if (mc == null) continue;
            if (mc.virgin) {
                mc.ghost = true;
                sum += (long)mc.getDataSize();
                continue;
            }
            this.microCaches[i] = null;
        }
        return sum;
    }

    long collectAll() {
        long deleted = 0L;
        int nc = this.microCaches == null ? 0 : this.microCaches.length;
        for (int i = 0; i < nc; ++i) {
            MicroCache mc = this.microCaches[i];
            if (mc == null || mc.ghost) continue;
            deleted += (long)mc.collect(0);
        }
        return deleted;
    }

    long cleanGhosts() {
        long deleted = 0L;
        int nc = this.microCaches == null ? 0 : this.microCaches.length;
        for (int i = 0; i < nc; ++i) {
            MicroCache mc = this.microCaches[i];
            if (mc == null || !mc.ghost) continue;
            this.microCaches[i] = null;
        }
        return deleted;
    }

    void cleanNonVirgin() {
        int nc = this.microCaches == null ? 0 : this.microCaches.length;
        for (int i = 0; i < nc; ++i) {
            MicroCache mc = this.microCaches[i];
            if (mc == null || mc.virgin) continue;
            this.microCaches[i] = null;
        }
    }
}

