/*
 * Decompiled with CFR 0.152.
 */
package btools.expressions;

import btools.codec.TagValueValidator;
import btools.expressions.BExpressionContext;
import btools.expressions.BExpressionMetaData;

public final class BExpressionContextWay
extends BExpressionContext
implements TagValueValidator {
    private boolean decodeForbidden = true;
    private static String[] buildInVariables = new String[]{"costfactor", "turncost", "uphillcostfactor", "downhillcostfactor", "initialcost", "nodeaccessgranted", "initialclassifier", "trafficsourcedensity", "istrafficbackbone", "priorityclassifier", "classifiermask"};

    @Override
    protected String[] getBuildInVariableNames() {
        return buildInVariables;
    }

    public float getCostfactor() {
        return this.getBuildInVariable(0);
    }

    public float getTurncost() {
        return this.getBuildInVariable(1);
    }

    public float getUphillCostfactor() {
        return this.getBuildInVariable(2);
    }

    public float getDownhillCostfactor() {
        return this.getBuildInVariable(3);
    }

    public float getInitialcost() {
        return this.getBuildInVariable(4);
    }

    public float getNodeAccessGranted() {
        return this.getBuildInVariable(5);
    }

    public float getInitialClassifier() {
        return this.getBuildInVariable(6);
    }

    public float getTrafficSourceDensity() {
        return this.getBuildInVariable(7);
    }

    public float getIsTrafficBackbone() {
        return this.getBuildInVariable(8);
    }

    public float getPriorityClassifier() {
        return this.getBuildInVariable(9);
    }

    public float getClassifierMask() {
        return this.getBuildInVariable(10);
    }

    public BExpressionContextWay(BExpressionMetaData meta) {
        super("way", meta);
    }

    public BExpressionContextWay(int hashSize, BExpressionMetaData meta) {
        super("way", hashSize, meta);
    }

    @Override
    public int accessType(byte[] description) {
        this.evaluate(false, description);
        float minCostFactor = this.getCostfactor();
        if (minCostFactor >= 9999.0f) {
            this.setInverseVars();
            float reverseCostFactor = this.getCostfactor();
            if (reverseCostFactor < minCostFactor) {
                minCostFactor = reverseCostFactor;
            }
        }
        return minCostFactor < 9999.0f ? 2 : (this.decodeForbidden ? (minCostFactor < 10000.0f ? 1 : 0) : 0);
    }

    @Override
    public void setDecodeForbidden(boolean decodeForbidden) {
        this.decodeForbidden = decodeForbidden;
    }
}

