/*
 * Decompiled with CFR 0.152.
 */
package btools.codec;

import btools.util.BitCoderContext;
import java.util.TreeMap;

public final class StatCoderContext
extends BitCoderContext {
    private static TreeMap<String, long[]> statsPerName;
    private long lastbitpos = 0L;

    public StatCoderContext(byte[] ab) {
        super(ab);
    }

    public void assignBits(String name) {
        long[] stats;
        long bitpos = this.getWritingBitPosition();
        if (statsPerName == null) {
            statsPerName = new TreeMap();
        }
        if ((stats = statsPerName.get(name)) == null) {
            stats = new long[2];
            statsPerName.put(name, stats);
        }
        stats[0] = stats[0] + (bitpos - this.lastbitpos);
        stats[1] = stats[1] + 1L;
        this.lastbitpos = bitpos;
    }

    public static String getBitReport() {
        if (statsPerName == null) {
            return "<empty bit report>";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : statsPerName.keySet()) {
            long[] stats = statsPerName.get(name);
            sb.append(name + " count=" + stats[1] + " bits=" + stats[0] + "\n");
        }
        statsPerName = null;
        return sb.toString();
    }

    public void encodeNoisyNumber(int value, int noisybits) {
        if (value < 0) {
            throw new IllegalArgumentException("encodeVarBits expects positive value");
        }
        if (noisybits > 0) {
            int mask = -1 >>> 32 - noisybits;
            this.encodeBounded(mask, value & mask);
            value >>= noisybits;
        }
        this.encodeVarBits(value);
    }

    public int decodeNoisyNumber(int noisybits) {
        int value = this.decodeBits(noisybits);
        return value | this.decodeVarBits() << noisybits;
    }

    public void encodeNoisyDiff(int value, int noisybits) {
        if (noisybits > 0) {
            int mask = -1 >>> 32 - noisybits;
            this.encodeBounded(mask, (value += 1 << noisybits - 1) & mask);
            value >>= noisybits;
        }
        this.encodeVarBits(value < 0 ? -value : value);
        if (value != 0) {
            this.encodeBit(value < 0);
        }
    }

    public int decodeNoisyDiff(int noisybits) {
        int val2;
        int value = 0;
        if (noisybits > 0) {
            value = this.decodeBits(noisybits) - (1 << noisybits - 1);
        }
        if ((val2 = this.decodeVarBits() << noisybits) != 0 && this.decodeBit()) {
            val2 = -val2;
        }
        return value + val2;
    }

    public void encodePredictedValue(int value, int predictor) {
        int noisybits = 0;
        for (int p = predictor < 0 ? -predictor : predictor; p > 2; p >>= 1) {
            ++noisybits;
        }
        this.encodeNoisyDiff(value - predictor, noisybits);
    }

    public int decodePredictedValue(int predictor) {
        int noisybits = 0;
        for (int p = predictor < 0 ? -predictor : predictor; p > 2; p >>= 1) {
            ++noisybits;
        }
        return predictor + this.decodeNoisyDiff(noisybits);
    }

    public void encodeSortedArray(int[] values, int offset, int subsize, int nextbit, int mask) {
        int i;
        if (subsize == 1) {
            while (nextbit != 0) {
                this.encodeBit((values[offset] & nextbit) != 0);
                nextbit >>= 1;
            }
        }
        if (nextbit == 0) {
            return;
        }
        int data = mask & values[offset];
        mask |= nextbit;
        int end = subsize + offset;
        for (i = offset; i < end && (values[i] & mask) == data; ++i) {
        }
        int size1 = i - offset;
        int size2 = subsize - size1;
        this.encodeBounded(subsize, size1);
        if (size1 > 0) {
            this.encodeSortedArray(values, offset, size1, nextbit >> 1, mask);
        }
        if (size2 > 0) {
            this.encodeSortedArray(values, i, size2, nextbit >> 1, mask);
        }
    }

    public void decodeSortedArray(int[] values, int offset, int subsize, int nextbit, int value) {
        if (subsize == 1) {
            while (nextbit != 0) {
                if (this.decodeBit()) {
                    value |= nextbit;
                }
                nextbit >>= 1;
            }
            values[offset] = value;
            return;
        }
        if (nextbit == 0) {
            while (subsize-- > 0) {
                values[offset++] = value;
            }
            return;
        }
        int size1 = this.decodeBounded(subsize);
        int size2 = subsize - size1;
        if (size1 > 0) {
            this.decodeSortedArray(values, offset, size1, nextbit >> 1, value);
        }
        if (size2 > 0) {
            this.decodeSortedArray(values, offset + size1, size2, nextbit >> 1, value | nextbit);
        }
    }
}

