/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class SortedHeap<V> {
    private int[][] al;
    private int[] lv;
    private int[] nextNonEmpty;
    private int firstNonEmpty;
    private int[] lp;
    private Object[][] vla;
    protected static final int MAXLISTS = 28;
    private int size;
    private boolean isClear = false;

    public SortedHeap() {
        this.clear();
    }

    public V popLowestKeyValue() {
        int idx = this.firstNonEmpty;
        if (idx < 0) {
            return null;
        }
        --this.size;
        int minId = this.lv[idx];
        int minIdx = idx;
        while ((idx = this.nextNonEmpty[idx]) >= 0) {
            if (this.lv[idx] >= minId) continue;
            minId = this.lv[idx];
            minIdx = idx;
        }
        return this.dropLowest(minIdx);
    }

    private V dropLowest(int idx) {
        int n = idx;
        int n2 = this.lp[n];
        this.lp[n] = n2 + 1;
        int lp_old = n2;
        int lp_new = lp_old + 1;
        if (lp_new == 4 << idx) {
            this.unlinkIdx(idx);
        } else {
            this.lv[idx] = this.al[idx][lp_new];
        }
        Object[] vlai = this.vla[idx];
        Object res = vlai[lp_old];
        vlai[lp_old] = null;
        return (V)res;
    }

    private void unlinkIdx(int idx) {
        if (idx == this.firstNonEmpty) {
            this.firstNonEmpty = this.nextNonEmpty[idx];
            return;
        }
        int i = this.firstNonEmpty;
        while (true) {
            if (this.nextNonEmpty[i] == idx) {
                this.nextNonEmpty[i] = this.nextNonEmpty[idx];
                return;
            }
            i = this.nextNonEmpty[i];
        }
    }

    public void add(int key, V value) {
        this.isClear = false;
        ++this.size;
        if (this.lp[0] == 0) {
            this.sortUp();
        }
        int lp0 = this.lp[0];
        int[] al0 = this.al[0];
        Object[] vla0 = this.vla[0];
        while (true) {
            if (lp0 == 4 || key < al0[lp0]) {
                al0[lp0 - 1] = key;
                vla0[lp0 - 1] = value;
                this.lp[0] = this.lp[0] - 1;
                this.lv[0] = al0[this.lp[0]];
                if (this.firstNonEmpty != 0) {
                    this.nextNonEmpty[0] = this.firstNonEmpty;
                    this.firstNonEmpty = 0;
                }
                return;
            }
            al0[lp0 - 1] = al0[lp0];
            vla0[lp0 - 1] = vla0[lp0];
            ++lp0;
        }
    }

    private void sortUp() {
        int cnt = 4;
        int idx = 1;
        int n = 8;
        int nonEmptyCount = 1;
        while (true) {
            int nentries;
            if ((nentries = n - this.lp[idx]) > 0) {
                cnt += n - this.lp[idx];
                ++nonEmptyCount;
            }
            if (cnt <= n) break;
            ++idx;
            n <<= 1;
        }
        if (this.al[idx] == null) {
            this.al[idx] = new int[n];
            this.vla[idx] = new Object[n];
        }
        int[] al_t = this.al[idx];
        Object[] vla_t = this.vla[idx];
        int tp = n - cnt;
        while (nonEmptyCount > 1) {
            int neIdx;
            int minIdx = neIdx = this.firstNonEmpty;
            int minId = this.lv[minIdx];
            for (int i = 1; i < nonEmptyCount; ++i) {
                if (this.lv[neIdx = this.nextNonEmpty[neIdx]] >= minId) continue;
                minIdx = neIdx;
                minId = this.lv[neIdx];
            }
            al_t[tp] = minId;
            vla_t[tp++] = this.dropLowest(minIdx);
            if (this.lp[minIdx] != 4 << minIdx) continue;
            --nonEmptyCount;
        }
        if (this.firstNonEmpty != idx) {
            int[] al_s = this.al[this.firstNonEmpty];
            Object[] vla_s = this.vla[this.firstNonEmpty];
            int sp = this.lp[this.firstNonEmpty];
            while (sp < 4 << this.firstNonEmpty) {
                al_t[tp] = al_s[sp];
                vla_t[tp++] = vla_s[sp];
                vla_s[sp++] = null;
            }
            this.lp[this.firstNonEmpty] = sp;
        }
        this.unlinkIdx(this.firstNonEmpty);
        this.lp[idx] = n - cnt;
        this.lv[idx] = this.al[idx][this.lp[idx]];
        this.nextNonEmpty[idx] = this.firstNonEmpty;
        this.firstNonEmpty = idx;
    }

    public void clear() {
        if (!this.isClear) {
            this.isClear = true;
            this.size = 0;
            this.lp = new int[28];
            this.al = new int[28][];
            this.al[0] = new int[4];
            this.vla = new Object[28][];
            this.vla[0] = new Object[4];
            this.lv = new int[28];
            this.nextNonEmpty = new int[28];
            this.firstNonEmpty = -1;
            int n = 4;
            for (int idx = 0; idx < 28; ++idx) {
                this.lp[idx] = n;
                n <<= 1;
                this.nextNonEmpty[idx] = -1;
            }
        }
    }

    public List<V> getExtract() {
        int[] ali;
        int div = this.size / 1000 + 1;
        ArrayList<Object> res = new ArrayList<Object>(this.size / div + 1);
        int lpi = 0;
        int i = 1;
        while ((ali = this.al[i]) != null) {
            lpi += this.lp[i];
            Object[] vlai = this.vla[i];
            int n = 4 << i;
            while (lpi < n) {
                res.add(this.vla[i][lpi]);
                lpi += div;
            }
            lpi -= n;
            ++i;
        }
        return res;
    }

    public static void main(String[] args) {
        String s;
        SortedHeap<String> sh = new SortedHeap<String>();
        Random rnd = new Random();
        for (int i = 0; i < 100; ++i) {
            int val = rnd.nextInt(1000000);
            sh.add(val, "" + val);
            val = rnd.nextInt(1000000);
            sh.add(val, "" + val);
            sh.popLowestKeyValue();
        }
        int cnt = 0;
        int lastval = 0;
        while ((s = (String)sh.popLowestKeyValue()) != null) {
            ++cnt;
            int val = Integer.parseInt(s);
            System.out.println("popLowestKeyValue: " + val);
            lastval = val;
        }
    }
}

