/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

final class TrainSchedule {
    private List<TrainScheduleCron> cronsPositive;
    private List<TrainScheduleCron> cronsNegative;
    private Map<String, List<Integer>> timeTable = new HashMap<String, List<Integer>>();
    private static Map<String, Set<String>> calendarMap;

    public TrainSchedule(String cronstring) {
        StringTokenizer tk = new StringTokenizer(cronstring, " ");
        this.cronsPositive = new ArrayList<TrainScheduleCron>();
        this.cronsNegative = new ArrayList<TrainScheduleCron>();
        while (tk.hasMoreTokens()) {
            String prefix = tk.nextToken();
            String value = tk.nextToken();
            if ("+".equals(prefix)) {
                this.cronsPositive.add(new TrainScheduleCron(value));
                continue;
            }
            if ("-".equals(prefix)) {
                this.cronsNegative.add(new TrainScheduleCron(value));
                continue;
            }
            ArrayList<Integer> times = new ArrayList<Integer>();
            StringTokenizer tk3 = new StringTokenizer(value, "/");
            while (tk3.hasMoreTokens()) {
                times.add(TrainSchedule.time2Minute(tk3.nextToken()));
            }
            Collections.sort(times);
            this.timeTable.put(prefix, times);
        }
    }

    private static int time2Minute(String s) {
        StringTokenizer tk = new StringTokenizer(s, ":");
        int mins = 60 * Integer.parseInt(tk.nextToken());
        return mins += Integer.parseInt(tk.nextToken());
    }

    public int getMinutesToNext(long timeFrom) {
        if (this.timeTable.isEmpty()) {
            return this.getMinutesToNextCron(timeFrom);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(timeFrom));
        int minute = cal.get(12);
        int hour = cal.get(11);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String sday = "" + (year * 10000 + month * 100 + day);
        List<Integer> alltimes = null;
        boolean listIsCopy = false;
        for (String calId : this.timeTable.keySet()) {
            if (!TrainSchedule.calendarHasDate(calId, sday)) continue;
            List<Integer> times = this.timeTable.get(calId);
            if (alltimes == null) {
                alltimes = times;
                continue;
            }
            if (!listIsCopy) {
                alltimes = new ArrayList<Integer>(alltimes);
                listIsCopy = true;
            }
            alltimes.addAll(times);
        }
        if (alltimes == null) {
            return -1;
        }
        if (listIsCopy) {
            Collections.sort(alltimes);
        }
        int mins = 60 * hour + minute;
        for (Integer t : alltimes) {
            if (t < mins) continue;
            return t - mins;
        }
        return -1;
    }

    private int getMinutesToNextCron(long timeFrom) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(timeFrom));
        int minute = cal.get(12);
        int hour = cal.get(11);
        int dow = cal.get(7);
        dow = dow > 1 ? dow - 1 : dow + 6;
        for (int cnt = 0; cnt < 180; ++cnt) {
            boolean veto = false;
            for (TrainScheduleCron cron : this.cronsNegative) {
                if (!cron.matches(minute, hour, dow)) continue;
                veto = true;
                break;
            }
            if (!veto) {
                for (TrainScheduleCron cron : this.cronsPositive) {
                    if (!cron.matches(minute, hour, dow)) continue;
                    return cnt;
                }
            }
            if (++minute != 60) continue;
            minute = 0;
            if (++hour != 24) continue;
            hour = 0;
            if (++dow != 8) continue;
            dow = 1;
        }
        return -1;
    }

    private static boolean calendarHasDate(String calId, String date) {
        Set<String> idSet;
        if (calendarMap == null) {
            try {
                TrainSchedule.readCalendar();
            }
            catch (Exception e) {
                throw new RuntimeException("cannot readcalendar: " + e);
            }
        }
        if ((idSet = calendarMap.get(calId)) != null) {
            return idSet.contains(date);
        }
        return true;
    }

    private static void readCalendar() throws Exception {
        String line;
        System.out.println("reading calendar...");
        calendarMap = new HashMap<String, Set<String>>();
        HashMap<String, String> uniqueMap = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File("../calendar_dates.txt")), "UTF-8"));
        br.readLine();
        while ((line = br.readLine()) != null) {
            String uniqueDate;
            StringTokenizer tk = new StringTokenizer(line, ",");
            String calId = tk.nextToken();
            String calDate = tk.nextToken();
            Set<String> idSet = calendarMap.get(calId);
            if (idSet == null) {
                idSet = new HashSet<String>();
                calendarMap.put(calId, idSet);
            }
            if ((uniqueDate = (String)uniqueMap.get(calDate)) == null) {
                uniqueDate = calDate;
                uniqueMap.put(uniqueDate, uniqueDate);
            }
            idSet.add(uniqueDate);
        }
        br.close();
        System.out.println("read calendar with " + calendarMap.size() + " ids");
    }

    private static class TrainScheduleCron {
        long minutes;
        long hours;
        long dows;

        TrainScheduleCron(String value) {
            StringTokenizer tk = new StringTokenizer(value, "_");
            this.minutes = this.parseElement(tk.nextToken());
            this.hours = this.parseElement(tk.nextToken());
            this.dows = this.parseElement(tk.nextToken());
        }

        private long parseElement(String s) {
            if ("*".equals(s)) {
                return Long.MAX_VALUE;
            }
            StringTokenizer tk = new StringTokenizer(s, ",");
            long res = 0L;
            while (tk.hasMoreTokens()) {
                int end;
                int start;
                String sub = tk.nextToken();
                int idx = sub.indexOf(45);
                if (idx < 0) {
                    end = start = Integer.parseInt(sub);
                } else {
                    start = Integer.parseInt(sub.substring(0, idx));
                    end = Integer.parseInt(sub.substring(idx + 1));
                }
                for (int i = start; i <= end; ++i) {
                    res |= 1L << i;
                }
            }
            return res;
        }

        boolean matches(int minute, int hour, int dow) {
            return (1L << minute & this.minutes) != 0L && (1L << hour & this.hours) != 0L && (1L << dow & this.dows) != 0L;
        }
    }
}

