/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import btools.memrouter.OffsetSetHolder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class OffsetSet {
    private Map<BitSet, OffsetSet> existingSets = new HashMap<BitSet, OffsetSet>();
    private static final int size = 185;
    protected BitSet mask;

    public OffsetSet emptySet() {
        return new OffsetSet(new BitSet(185), this.existingSets);
    }

    public static OffsetSet fullSet() {
        BitSet allbits = new BitSet(185);
        allbits.set(0, 185);
        return new OffsetSet(allbits, new HashMap<BitSet, OffsetSet>());
    }

    private OffsetSet(BitSet m, Map<BitSet, OffsetSet> knownSets) {
        this.existingSets = knownSets;
        this.existingSets.put(m, this);
        this.mask = m;
    }

    private OffsetSet create(BitSet m) {
        if (m.isEmpty()) {
            return null;
        }
        if (m.equals(this.mask)) {
            return this;
        }
        OffsetSet set = this.existingSets.get(m);
        if (set == null) {
            set = new OffsetSet(m, this.existingSets);
        }
        return set;
    }

    public OffsetSet create(List<Integer> offsets) {
        BitSet m = new BitSet(185);
        for (Integer offset : offsets) {
            int i = offset;
            if (i < 0 || i >= 185) continue;
            m.set(i);
        }
        return this.create(m);
    }

    public OffsetSet filterWithSet(SortedSet<Integer> usedTimes, int minuteArrival) {
        int maxtime;
        BitSet fmask = (BitSet)this.mask.clone();
        int idx = 0;
        int n = maxtime = usedTimes.isEmpty() ? Integer.MAX_VALUE : usedTimes.first() + this.size();
        while ((idx = fmask.nextSetBit(idx)) >= 0) {
            int i = minuteArrival + idx;
            if (i > maxtime || !usedTimes.add(i)) {
                fmask.set(idx, false);
            }
            ++idx;
        }
        return this.create(fmask);
    }

    public int size() {
        return 185;
    }

    public boolean contains(int offset) {
        return this.mask.get(offset);
    }

    public OffsetSet add(int offset) {
        if (this.mask.get(offset)) {
            return this;
        }
        BitSet m = (BitSet)this.mask.clone();
        m.set(offset);
        return this.create(m);
    }

    public OffsetSet add(OffsetSet offsets) {
        BitSet m = (BitSet)this.mask.clone();
        m.or(offsets.mask);
        return this.create(m);
    }

    public OffsetSet filter(OffsetSet in) {
        BitSet fmask = (BitSet)in.mask.clone();
        fmask.andNot(this.mask);
        return this.create(fmask);
    }

    public OffsetSet ensureMaxOffset(int max) {
        if (max < 185) {
            BitSet fmask = (BitSet)this.mask.clone();
            fmask.set(max > 0 ? max : 0, 185, false);
            return this.create(fmask);
        }
        return this;
    }

    public OffsetSet filterAndClose(OffsetSetHolder gateHolder, boolean closeGate) {
        OffsetSet gate = gateHolder.getOffsetSet();
        BitSet gmask = (BitSet)gate.mask.clone();
        BitSet fmask = (BitSet)this.mask.clone();
        fmask.andNot(gmask);
        gmask.or(fmask);
        if (closeGate) {
            gateHolder.setOffsetSet(this.create(gmask));
        }
        return this.create(fmask);
    }

    public OffsetSet sweepWith(OffsetSet sweeper, int timeDiff) {
        BitSet sweepmask = sweeper.mask;
        BitSet fmask = (BitSet)this.mask.clone();
        if (timeDiff >= 0) {
            int sweepStart;
            int idx = 0;
            while ((idx = sweepmask.nextSetBit(idx) + 1) >= 1) {
                sweepStart = Math.max(0, idx - timeDiff);
                fmask.set(sweepStart, idx, false);
            }
            sweepStart = Math.max(0, 185 - timeDiff);
            fmask.set(sweepStart, 185, false);
        }
        return this.create(fmask);
    }

    public String toString() {
        return this.mask.toString();
    }
}

