/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmTransferNode;
import btools.util.ByteDataReader;

public final class GeometryDecoder {
    private ByteDataReader r = new ByteDataReader(null);
    private OsmTransferNode[] cachedNodes = new OsmTransferNode[this.nCachedNodes];
    private int nCachedNodes = 128;

    public GeometryDecoder() {
        for (int i = 0; i < this.nCachedNodes; ++i) {
            this.cachedNodes[i] = new OsmTransferNode();
        }
    }

    public OsmTransferNode decodeGeometry(byte[] geometry, OsmNode sourceNode, OsmNode targetNode, boolean reverseLink) {
        OsmTransferNode firstTransferNode = null;
        OsmTransferNode lastTransferNode = null;
        OsmNode startnode = reverseLink ? targetNode : sourceNode;
        this.r.reset(geometry);
        int olon = startnode.ilon;
        int olat = startnode.ilat;
        short oselev = startnode.selev;
        int idx = 0;
        while (this.r.hasMoreData()) {
            OsmTransferNode trans = idx < this.nCachedNodes ? this.cachedNodes[idx++] : new OsmTransferNode();
            trans.ilon = olon + this.r.readVarLengthSigned();
            trans.ilat = olat + this.r.readVarLengthSigned();
            trans.selev = (short)(oselev + this.r.readVarLengthSigned());
            olon = trans.ilon;
            olat = trans.ilat;
            oselev = trans.selev;
            if (reverseLink) {
                trans.next = firstTransferNode;
                firstTransferNode = trans;
                continue;
            }
            trans.next = null;
            if (lastTransferNode == null) {
                firstTransferNode = trans;
            } else {
                lastTransferNode.next = trans;
            }
            lastTransferNode = trans;
        }
        return firstTransferNode;
    }
}

