/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.util.ArrayList;

public class DenseLongMap {
    private ArrayList<byte[]> blocklist = new ArrayList(4096);
    private int blocksize;
    private int blocksizeBits;
    private long blocksizeBitsMask;
    private int maxvalue = 254;
    private int[] bitplaneCount = new int[8];
    private long putCount = 0L;
    private long getCount = 0L;

    public DenseLongMap() {
        this(512);
    }

    public DenseLongMap(int blocksize) {
        int bits;
        for (bits = 4; bits < 28 && 1 << bits != blocksize; ++bits) {
        }
        if (bits == 28) {
            throw new RuntimeException("not a valid blocksize: " + blocksize + " ( expected 1 << bits with bits in (4..27) )");
        }
        this.blocksizeBits = bits + 3;
        this.blocksizeBitsMask = (1L << this.blocksizeBits) - 1L;
        this.blocksize = blocksize;
    }

    public void put(long key, int value) {
        int idx;
        ++this.putCount;
        if (value < 0 || value > this.maxvalue) {
            throw new IllegalArgumentException("value out of range (0.." + this.maxvalue + "): " + value);
        }
        int blockn = (int)(key >> this.blocksizeBits);
        int offset = (int)(key & this.blocksizeBitsMask);
        byte[] block = blockn < this.blocklist.size() ? this.blocklist.get(blockn) : null;
        int valuebits = 1;
        if (block == null) {
            block = new byte[this.sizeForBits(valuebits)];
            this.bitplaneCount[0] = this.bitplaneCount[0] + 1;
            while (this.blocklist.size() < blockn + 1) {
                this.blocklist.add(null);
            }
            this.blocklist.set(blockn, block);
        } else {
            while (this.sizeForBits(valuebits) < block.length) {
                ++valuebits;
            }
        }
        int headersize = 1 << valuebits;
        byte v = (byte)(value + 1);
        for (idx = 1; idx < headersize; ++idx) {
            if (block[idx] == 0) {
                block[idx] = v;
            }
            if (block[idx] == v) break;
        }
        if (idx == headersize) {
            block = this.expandBlock(block, valuebits);
            block[idx] = v;
            this.blocklist.set(blockn, block);
            headersize = 1 << ++valuebits;
        }
        int bitmask = 1 << (offset & 7);
        int invmask = bitmask ^ 0xFF;
        int probebit = 1;
        int blockidx = (offset >> 3) + headersize;
        for (int i = 0; i < valuebits; ++i) {
            if ((idx & probebit) != 0) {
                int n = blockidx;
                block[n] = (byte)(block[n] | bitmask);
            } else {
                int n = blockidx;
                block[n] = (byte)(block[n] & invmask);
            }
            probebit <<= 1;
            blockidx += this.blocksize;
        }
    }

    private int sizeForBits(int bits) {
        return (1 << bits) + this.blocksize * bits;
    }

    private byte[] expandBlock(byte[] block, int valuebits) {
        int n = valuebits;
        this.bitplaneCount[n] = this.bitplaneCount[n] + 1;
        byte[] newblock = new byte[this.sizeForBits(valuebits + 1)];
        int headersize = 1 << valuebits;
        System.arraycopy(block, 0, newblock, 0, headersize);
        System.arraycopy(block, headersize, newblock, 2 * headersize, block.length - headersize);
        return newblock;
    }

    public int getInt(long key) {
        byte[] block;
        if (this.getCount++ == 0L) {
            System.out.println("**** DenseLongMap stats ****");
            System.out.println("putCount=" + this.putCount);
            for (int i = 0; i < 8; ++i) {
                System.out.println(i + "-bitplanes=" + this.bitplaneCount[i]);
            }
            System.out.println("****************************");
        }
        if (key < 0L) {
            return -1;
        }
        int blockn = (int)(key >> this.blocksizeBits);
        int offset = (int)(key & this.blocksizeBitsMask);
        byte[] byArray = block = blockn < this.blocklist.size() ? this.blocklist.get(blockn) : null;
        if (block == null) {
            return -1;
        }
        int valuebits = 1;
        while (this.sizeForBits(valuebits) < block.length) {
            ++valuebits;
        }
        int headersize = 1 << valuebits;
        int bitmask = 1 << (offset & 7);
        int probebit = 1;
        int blockidx = (offset >> 3) + headersize;
        int idx = 0;
        for (int i = 0; i < valuebits; ++i) {
            if ((block[blockidx] & bitmask) != 0) {
                idx |= probebit;
            }
            probebit <<= 1;
            blockidx += this.blocksize;
        }
        return (256 + block[idx] & 0xFF) - 1;
    }
}

