/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

public class ByteDataReader {
    protected byte[] ab;
    protected int aboffset;
    protected int aboffsetEnd;

    public ByteDataReader(byte[] byteArray) {
        this.ab = byteArray;
        this.aboffsetEnd = this.ab == null ? 0 : this.ab.length;
    }

    public ByteDataReader(byte[] byteArray, int offset) {
        this.ab = byteArray;
        this.aboffset = offset;
        this.aboffsetEnd = this.ab == null ? 0 : this.ab.length;
    }

    public final int readInt() {
        int i3 = this.ab[this.aboffset++] & 0xFF;
        int i2 = this.ab[this.aboffset++] & 0xFF;
        int i1 = this.ab[this.aboffset++] & 0xFF;
        int i0 = this.ab[this.aboffset++] & 0xFF;
        return (i3 << 24) + (i2 << 16) + (i1 << 8) + i0;
    }

    public final long readLong() {
        long i7 = this.ab[this.aboffset++] & 0xFF;
        long i6 = this.ab[this.aboffset++] & 0xFF;
        long i5 = this.ab[this.aboffset++] & 0xFF;
        long i4 = this.ab[this.aboffset++] & 0xFF;
        long i3 = this.ab[this.aboffset++] & 0xFF;
        long i2 = this.ab[this.aboffset++] & 0xFF;
        long i1 = this.ab[this.aboffset++] & 0xFF;
        long i0 = this.ab[this.aboffset++] & 0xFF;
        return (i7 << 56) + (i6 << 48) + (i5 << 40) + (i4 << 32) + (i3 << 24) + (i2 << 16) + (i1 << 8) + i0;
    }

    public final boolean readBoolean() {
        int i0;
        return (i0 = this.ab[this.aboffset++] & 0xFF) != 0;
    }

    public final byte readByte() {
        int i0 = this.ab[this.aboffset++] & 0xFF;
        return (byte)i0;
    }

    public final short readShort() {
        int i1 = this.ab[this.aboffset++] & 0xFF;
        int i0 = this.ab[this.aboffset++] & 0xFF;
        return (short)(i1 << 8 | i0);
    }

    public int getEndPointer() {
        int size = this.readVarLengthUnsigned();
        return this.aboffset + size;
    }

    public byte[] readDataUntil(int endPointer) {
        int size = endPointer - this.aboffset;
        if (size == 0) {
            return null;
        }
        byte[] data = new byte[size];
        this.readFully(data);
        return data;
    }

    public byte[] readVarBytes() {
        int len = this.readVarLengthUnsigned();
        if (len == 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        this.readFully(bytes);
        return bytes;
    }

    public final int readVarLengthSigned() {
        int v = this.readVarLengthUnsigned();
        return (v & 1) == 0 ? v >> 1 : -(v >> 1);
    }

    public final int readVarLengthUnsigned() {
        byte b = this.ab[this.aboffset++];
        int v = b & 0x7F;
        if (b >= 0) {
            return v;
        }
        b = this.ab[this.aboffset++];
        v |= (b & 0x7F) << 7;
        if (b >= 0) {
            return v;
        }
        b = this.ab[this.aboffset++];
        v |= (b & 0x7F) << 14;
        if (b >= 0) {
            return v;
        }
        b = this.ab[this.aboffset++];
        v |= (b & 0x7F) << 21;
        if (b >= 0) {
            return v;
        }
        b = this.ab[this.aboffset++];
        return v |= (b & 0xF) << 28;
    }

    public final void readFully(byte[] ta) {
        System.arraycopy(this.ab, this.aboffset, ta, 0, ta.length);
        this.aboffset += ta.length;
    }

    public boolean hasMoreData() {
        return this.aboffset < this.aboffsetEnd;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.ab.length; ++i) {
            sb.append(i == 0 ? " " : ", ").append(Integer.toString(this.ab[i]));
        }
        sb.append(" ]");
        return sb.toString();
    }
}

