/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.expressions.BExpressionContext;
import btools.expressions.BExpressionContextNode;
import btools.expressions.BExpressionContextWay;
import btools.router.OsmNodeNamed;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;

public final class RoutingContext {
    public int alternativeIdx = 0;
    public String localFunction;
    public long profileTimestamp;
    public String rawTrackPath;
    public BExpressionContextWay expctxWay;
    public BExpressionContextNode expctxNode;
    public boolean serversizing = false;
    public int downhillcostdiv;
    public int downhillcutoff;
    public int uphillcostdiv;
    public int uphillcutoff;
    public boolean carMode;
    public boolean bikeMode;
    public boolean forceSecondaryData;
    public double pass1coefficient;
    public double pass2coefficient;
    public int elevationpenaltybuffer;
    public int elevationmaxbuffer;
    public int elevationbufferreduce;
    public double cost1speed;
    public double additionalcostfactor;
    public double changetime;
    public double buffertime;
    public double waittimeadjustment;
    public double inittimeadjustment;
    public double starttimeoffset;
    public boolean transitonly;
    public List<OsmNodeNamed> nogopoints = null;
    private List<OsmNodeNamed> keepnogopoints = null;
    private double coslat;
    public boolean nogomatch = false;
    public boolean isEndpoint = false;
    public boolean shortestmatch = false;
    public double wayfraction;
    public int ilatshortest;
    public int ilonshortest;
    public boolean countTraffic;
    public boolean inverseDirection;
    public DataOutput trafficOutputStream;
    public double farTrafficWeight;
    public double nearTrafficWeight;
    public double farTrafficDecayLength;
    public double nearTrafficDecayLength;
    public double trafficDirectionFactor;
    public double trafficSourceExponent;
    public double trafficSourceMinDist;
    public int turnInstructionMode;
    public double turnInstructionCatchingRange;
    public boolean turnInstructionRoundabouts;

    public void setAlternativeIdx(int idx) {
        this.alternativeIdx = idx;
    }

    public int getAlternativeIdx(int min, int max) {
        return this.alternativeIdx < min ? min : (this.alternativeIdx > max ? max : this.alternativeIdx);
    }

    public String getProfileName() {
        int idx;
        String name;
        String string = name = this.localFunction == null ? "unknown" : this.localFunction;
        if (name.endsWith(".brf")) {
            name = name.substring(0, this.localFunction.length() - 4);
        }
        if ((idx = name.lastIndexOf(47)) >= 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public void readGlobalConfig(BExpressionContext expctxGlobal) {
        this.downhillcostdiv = (int)expctxGlobal.getVariableValue("downhillcost", 0.0f);
        this.downhillcutoff = (int)(expctxGlobal.getVariableValue("downhillcutoff", 0.0f) * 10000.0f);
        this.uphillcostdiv = (int)expctxGlobal.getVariableValue("uphillcost", 0.0f);
        this.uphillcutoff = (int)(expctxGlobal.getVariableValue("uphillcutoff", 0.0f) * 10000.0f);
        if (this.downhillcostdiv != 0) {
            this.downhillcostdiv = 1000000 / this.downhillcostdiv;
        }
        if (this.uphillcostdiv != 0) {
            this.uphillcostdiv = 1000000 / this.uphillcostdiv;
        }
        this.carMode = 0.0f != expctxGlobal.getVariableValue("validForCars", 0.0f);
        this.bikeMode = 0.0f != expctxGlobal.getVariableValue("validForBikes", 0.0f);
        this.forceSecondaryData = 0.0f != expctxGlobal.getVariableValue("forceSecondaryData", 0.0f);
        this.pass1coefficient = expctxGlobal.getVariableValue("pass1coefficient", 1.5f);
        this.pass2coefficient = expctxGlobal.getVariableValue("pass2coefficient", 0.0f);
        this.elevationpenaltybuffer = (int)(expctxGlobal.getVariableValue("elevationpenaltybuffer", 5.0f) * 1000000.0f);
        this.elevationmaxbuffer = (int)(expctxGlobal.getVariableValue("elevationmaxbuffer", 10.0f) * 1000000.0f);
        this.elevationbufferreduce = (int)(expctxGlobal.getVariableValue("elevationbufferreduce", 0.0f) * 10000.0f);
        this.cost1speed = expctxGlobal.getVariableValue("cost1speed", 22.0f);
        this.additionalcostfactor = expctxGlobal.getVariableValue("additionalcostfactor", 1.5f);
        this.changetime = expctxGlobal.getVariableValue("changetime", 180.0f);
        this.buffertime = expctxGlobal.getVariableValue("buffertime", 120.0f);
        this.waittimeadjustment = expctxGlobal.getVariableValue("waittimeadjustment", 0.9f);
        this.inittimeadjustment = expctxGlobal.getVariableValue("inittimeadjustment", 0.2f);
        this.starttimeoffset = expctxGlobal.getVariableValue("starttimeoffset", 0.0f);
        this.transitonly = expctxGlobal.getVariableValue("transitonly", 0.0f) != 0.0f;
        this.farTrafficWeight = expctxGlobal.getVariableValue("farTrafficWeight", 2.0f);
        this.nearTrafficWeight = expctxGlobal.getVariableValue("nearTrafficWeight", 2.0f);
        this.farTrafficDecayLength = expctxGlobal.getVariableValue("farTrafficDecayLength", 30000.0f);
        this.nearTrafficDecayLength = expctxGlobal.getVariableValue("nearTrafficDecayLength", 3000.0f);
        this.trafficDirectionFactor = expctxGlobal.getVariableValue("trafficDirectionFactor", 0.9f);
        this.trafficSourceExponent = expctxGlobal.getVariableValue("trafficSourceExponent", -0.7f);
        this.trafficSourceMinDist = expctxGlobal.getVariableValue("trafficSourceMinDist", 3000.0f);
        int tiMode = (int)expctxGlobal.getVariableValue("turnInstructionMode", 0.0f);
        if (tiMode != 1) {
            this.turnInstructionMode = tiMode;
        }
        this.turnInstructionCatchingRange = expctxGlobal.getVariableValue("turnInstructionCatchingRange", 40.0f);
        this.turnInstructionRoundabouts = expctxGlobal.getVariableValue("turnInstructionRoundabouts", 1.0f) != 0.0f;
    }

    public static void prepareNogoPoints(List<OsmNodeNamed> nogos) {
        for (OsmNodeNamed nogo : nogos) {
            String s = nogo.name;
            int idx = s.indexOf(32);
            if (idx > 0) {
                s = s.substring(0, idx);
            }
            int ir = 20;
            if (s.length() > 4) {
                try {
                    ir = Integer.parseInt(s.substring(4));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            nogo.radius = (double)ir / 111894.0;
        }
    }

    public void cleanNogolist(List<OsmNodeNamed> waypoints) {
        if (this.nogopoints == null) {
            return;
        }
        ArrayList<OsmNodeNamed> nogos = new ArrayList<OsmNodeNamed>();
        for (OsmNodeNamed nogo : this.nogopoints) {
            int radiusInMeter = (int)(nogo.radius * 111894.0);
            boolean goodGuy = true;
            for (OsmNodeNamed wp : waypoints) {
                if (wp.calcDistance(nogo) >= radiusInMeter) continue;
                goodGuy = false;
                break;
            }
            if (!goodGuy) continue;
            nogos.add(nogo);
        }
        this.nogopoints = nogos;
    }

    public long[] getNogoChecksums() {
        long[] cs = new long[3];
        int n = this.nogopoints == null ? 0 : this.nogopoints.size();
        for (int i = 0; i < n; ++i) {
            OsmNodeNamed nogo = this.nogopoints.get(i);
            cs[0] = cs[0] + (long)nogo.ilon;
            cs[1] = cs[1] + (long)nogo.ilat;
            cs[2] = cs[2] + (long)(nogo.radius * 111894.0 * 10.0);
        }
        return cs;
    }

    public void setWaypoint(OsmNodeNamed wp, boolean endpoint) {
        this.keepnogopoints = this.nogopoints;
        this.nogopoints = new ArrayList<OsmNodeNamed>();
        this.nogopoints.add(wp);
        if (this.keepnogopoints != null) {
            this.nogopoints.addAll(this.keepnogopoints);
        }
        this.isEndpoint = endpoint;
    }

    public void unsetWaypoint() {
        this.nogopoints = this.keepnogopoints;
        this.isEndpoint = false;
    }

    public int calcDistance(int lon1, int lat1, int lon2, int lat2) {
        double l = (double)(lat2 - 90000000) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        this.coslat = 1.0 - l2 + l4 / 6.0;
        double coslat6 = this.coslat * 1.0E-6;
        double dx = (double)(lon2 - lon1) * coslat6;
        double dy = (double)(lat2 - lat1) * 1.0E-6;
        double d = Math.sqrt(dy * dy + dx * dx);
        this.shortestmatch = false;
        if (this.nogopoints != null && !this.nogopoints.isEmpty() && d > 0.0) {
            for (int ngidx = 0; ngidx < this.nogopoints.size(); ++ngidx) {
                OsmNodeNamed nogo = this.nogopoints.get(ngidx);
                double x1 = (double)(lon1 - nogo.ilon) * coslat6;
                double y1 = (double)(lat1 - nogo.ilat) * 1.0E-6;
                double r12 = x1 * x1 + y1 * y1;
                double x2 = (double)(lon2 - nogo.ilon) * coslat6;
                double y2 = (double)(lat2 - nogo.ilat) * 1.0E-6;
                double r22 = x2 * x2 + y2 * y2;
                double radius = Math.abs(r12 < r22 ? y1 * dx - x1 * dy : y2 * dx - x2 * dy) / d;
                if (!(radius < nogo.radius)) continue;
                double s1 = x1 * dx + y1 * dy;
                double s2 = x2 * dx + y2 * dy;
                if (s1 < 0.0) {
                    s1 = -s1;
                    s2 = -s2;
                }
                if (s2 > 0.0 && (radius = Math.sqrt(s1 < s2 ? r12 : r22)) > nogo.radius) continue;
                if (nogo.isNogo) {
                    this.nogomatch = true;
                    continue;
                }
                this.shortestmatch = true;
                nogo.radius = radius;
                if (s2 < 0.0) {
                    this.wayfraction = -s2 / (d * d);
                    double xm = x2 - this.wayfraction * dx;
                    double ym = y2 - this.wayfraction * dy;
                    this.ilonshortest = (int)(xm / coslat6 + (double)nogo.ilon);
                    this.ilatshortest = (int)(ym / 1.0E-6 + (double)nogo.ilat);
                } else if (s1 > s2) {
                    this.wayfraction = 0.0;
                    this.ilonshortest = lon2;
                    this.ilatshortest = lat2;
                } else {
                    this.wayfraction = 1.0;
                    this.ilonshortest = lon1;
                    this.ilatshortest = lat1;
                }
                if (this.isEndpoint) {
                    this.wayfraction = 1.0 - this.wayfraction;
                    lon2 = this.ilonshortest;
                    lat2 = this.ilatshortest;
                } else {
                    this.nogomatch = false;
                    lon1 = this.ilonshortest;
                    lat1 = this.ilatshortest;
                }
                dx = (double)(lon2 - lon1) * coslat6;
                dy = (double)(lat2 - lat1) * 1.0E-6;
                d = Math.sqrt(dy * dy + dx * dx);
            }
        }
        double dd = d * 111894.7368;
        return (int)(dd + 1.0);
    }

    public double calcCosAngle(int lon0, int lat0, int lon1, int lat1, int lon2, int lat2) {
        double dlat1 = lat1 - lat0;
        double dlon1 = (double)(lon1 - lon0) * this.coslat;
        double dlat2 = lat2 - lat1;
        double dlon2 = (double)(lon2 - lon1) * this.coslat;
        double dd = Math.sqrt((dlat1 * dlat1 + dlon1 * dlon1) * (dlat2 * dlat2 + dlon2 * dlon2));
        if (dd == 0.0) {
            return 0.0;
        }
        double cosp = (dlat1 * dlat2 + dlon1 * dlon2) / dd;
        return 1.0 - cosp;
    }

    public double calcAngle(int lon0, int lat0, int lon1, int lat1, int lon2, int lat2) {
        double p;
        double dlat1 = lat1 - lat0;
        double dlon1 = (double)(lon1 - lon0) * this.coslat;
        double dlat2 = lat2 - lat1;
        double dlon2 = (double)(lon2 - lon1) * this.coslat;
        double dd = Math.sqrt((dlat1 * dlat1 + dlon1 * dlon1) * (dlat2 * dlat2 + dlon2 * dlon2));
        if (dd == 0.0) {
            return 0.0;
        }
        double sinp = (dlat1 * dlon2 - dlon1 * dlat2) / dd;
        double cosp = (dlat1 * dlat2 + dlon1 * dlon2) / dd;
        if (sinp > -0.7 && sinp < 0.7) {
            p = Math.asin(sinp) * 57.3;
            if (cosp < 0.0) {
                p = 180.0 - p;
            }
        } else {
            p = Math.acos(cosp) * 57.3;
            if (sinp < 0.0) {
                p = -p;
            }
        }
        if (p > 180.0) {
            p -= 360.0;
        }
        return p;
    }
}

