/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.router.OsmPathElement;
import btools.router.RoutingContext;
import java.io.IOException;

public final class OsmPathElementWithTraffic
extends OsmPathElement {
    private int registerCount;
    private float farTraffic;
    private float nearTraffic;
    public static double maxtraffic = 0.0;

    public void register() {
        if (this.registerCount++ == 0 && this.origin instanceof OsmPathElementWithTraffic) {
            OsmPathElementWithTraffic ot = (OsmPathElementWithTraffic)this.origin;
            ot.register();
            ot.farTraffic += this.farTraffic;
            ot.nearTraffic += this.nearTraffic;
            this.farTraffic = 0.0f;
            this.nearTraffic = 0.0f;
        }
    }

    @Override
    public void addTraffic(float traffic) {
        this.farTraffic += traffic;
        this.nearTraffic += traffic;
    }

    public boolean unregister(RoutingContext rc) throws IOException {
        if (--this.registerCount == 0) {
            if (this.origin instanceof OsmPathElementWithTraffic) {
                int t2;
                OsmPathElementWithTraffic ot = (OsmPathElementWithTraffic)this.origin;
                int costdelta = this.cost - ot.cost;
                ot.farTraffic = (float)((double)ot.farTraffic + (double)this.farTraffic * Math.exp((double)(-costdelta) / rc.farTrafficDecayLength));
                ot.nearTraffic = (float)((double)ot.nearTraffic + (double)this.nearTraffic * Math.exp((double)(-costdelta) / rc.nearTrafficDecayLength));
                if (costdelta > 0 && (double)this.farTraffic > maxtraffic) {
                    maxtraffic = this.farTraffic;
                }
                int n = t2 = this.cost == ot.cost ? -1 : (int)(rc.farTrafficWeight * (double)this.farTraffic + rc.nearTrafficWeight * (double)this.nearTraffic);
                if ((t2 > 4000 || t2 == -1) && rc.trafficOutputStream != null) {
                    rc.trafficOutputStream.writeLong(this.getIdFromPos());
                    rc.trafficOutputStream.writeLong(ot.getIdFromPos());
                    rc.trafficOutputStream.writeInt(t2);
                }
                this.farTraffic = 0.0f;
                this.nearTraffic = 0.0f;
            }
            return true;
        }
        return false;
    }
}

