/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import btools.memrouter.OffsetSet;
import btools.memrouter.OffsetSetHolder;
import btools.memrouter.OsmNodeP;

public class OsmLinkP
implements OffsetSetHolder {
    public byte[] descriptionBitmap;
    protected OsmNodeP sourceNode;
    protected OsmNodeP targetNode;
    protected OsmLinkP previous;
    protected OsmLinkP next;
    public static int currentserial = 0;
    private int instanceserial = 0;
    private OffsetSet offsets;

    public boolean isConnection() {
        return this.descriptionBitmap == null;
    }

    public boolean isWayLink() {
        return this.descriptionBitmap != null;
    }

    public OsmLinkP(OsmNodeP source, OsmNodeP target) {
        this.sourceNode = source;
        this.targetNode = target;
    }

    protected OsmLinkP() {
    }

    @Override
    public OffsetSet getOffsetSet() {
        return this.offsets;
    }

    @Override
    public void setOffsetSet(OffsetSet offsets) {
        this.offsets = offsets;
    }

    public boolean isVirgin() {
        return this.instanceserial != currentserial;
    }

    public OffsetSet filterAndClose(OffsetSet in, long arrival) {
        if (this.offsets == null || this.isVirgin()) {
            this.initLink();
            this.offsets = in;
            return in;
        }
        return in.filterAndClose(this, true);
    }

    protected void initLink() {
        this.instanceserial = currentserial;
    }

    public void setNext(OsmLinkP link, OsmNodeP source) {
        if (this.sourceNode == source) {
            this.next = link;
        } else if (this.targetNode == source) {
            this.previous = link;
        } else {
            throw new IllegalArgumentException("internal error: setNext: unknown source");
        }
    }

    public OsmLinkP getNext(OsmNodeP source) {
        if (this.sourceNode == source) {
            return this.next;
        }
        if (this.targetNode == source) {
            return this.previous;
        }
        throw new IllegalArgumentException("internal error: gextNext: unknown source");
    }

    public OsmNodeP getTarget(OsmNodeP source) {
        if (this.sourceNode == source) {
            return this.targetNode;
        }
        if (this.targetNode == source) {
            return this.sourceNode;
        }
        throw new IllegalArgumentException("internal error: getTarget: unknown source");
    }

    public boolean isReverse(OsmNodeP source) {
        if (this.sourceNode == source) {
            return false;
        }
        if (this.targetNode == source) {
            return true;
        }
        throw new IllegalArgumentException("internal error: isReverse: unknown source");
    }
}

