/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.MicroCache;
import btools.codec.MicroCache2;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNodesMap;
import btools.mapaccess.OsmPos;
import btools.util.ByteArrayUnifier;
import btools.util.IByteArrayUnifier;

public class OsmNode
implements OsmPos {
    public int ilat;
    public int ilon;
    public short selev;
    public byte[] nodeDescription;
    public OsmLink firstlink = null;

    public OsmNode() {
    }

    public OsmNode(int ilon, int ilat) {
        this.ilon = ilon;
        this.ilat = ilat;
    }

    public OsmNode(long id) {
        this.ilon = (int)(id >> 32);
        this.ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public final int getILat() {
        return this.ilat;
    }

    @Override
    public final int getILon() {
        return this.ilon;
    }

    @Override
    public final short getSElev() {
        return this.selev;
    }

    @Override
    public final double getElev() {
        return (double)this.selev / 4.0;
    }

    public final void addLink(OsmLink link) {
        if (this.firstlink == null) {
            this.firstlink = link;
        } else {
            OsmLink l = this.firstlink;
            while (l.next != null) {
                l = l.next;
            }
            l.next = link;
        }
    }

    private OsmLink getCompatibleLink(int ilon, int ilat, boolean counterLinkWritten, int state) {
        OsmNode t;
        OsmLink l = this.firstlink;
        while (l != null) {
            if (counterLinkWritten == l.counterLinkWritten && l.state == state) {
                t = l.targetNode;
                if (t.ilon == ilon && t.ilat == ilat) {
                    l.state = 0;
                    return l;
                }
            }
            l = l.next;
        }
        l = this.firstlink;
        while (l != null) {
            if (l.state == state) {
                t = l.targetNode;
                if (t.ilon == ilon && t.ilat == ilat) {
                    l.state = 0;
                    return l;
                }
            }
            l = l.next;
        }
        return null;
    }

    @Override
    public final int calcDistance(OsmPos p) {
        double l = (double)(this.ilat - 90000000) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        double coslat = 1.0 - l2 + l4 / 6.0;
        double dlat = (double)(this.ilat - p.getILat()) / 1000000.0;
        double dlon = (double)(this.ilon - p.getILon()) / 1000000.0 * coslat;
        double d = Math.sqrt(dlat * dlat + dlon * dlon) * 111308.90052356021;
        return (int)(d + 1.0);
    }

    public String toString() {
        return "" + this.getIdFromPos();
    }

    public final void parseNodeBody(MicroCache mc, OsmNodesMap hollowNodes, IByteArrayUnifier expCtxWay) {
        if (!(mc instanceof MicroCache2)) {
            throw new IllegalArgumentException("unknown cache version: " + mc.getClass());
        }
        this.parseNodeBody2((MicroCache2)mc, hollowNodes, expCtxWay);
    }

    public final void parseNodeBody2(MicroCache2 mc, OsmNodesMap hollowNodes, IByteArrayUnifier expCtxWay) {
        ByteArrayUnifier abUnifier = hollowNodes.getByteArrayUnifier();
        this.selev = mc.readShort();
        int nodeDescSize = mc.readVarLengthUnsigned();
        byte[] byArray = this.nodeDescription = nodeDescSize == 0 ? null : mc.readUnified(nodeDescSize, abUnifier);
        while (mc.hasMoreData()) {
            OsmLink rlink;
            int endPointer = mc.getEndPointer();
            int linklon = this.ilon + mc.readVarLengthSigned();
            int linklat = this.ilat + mc.readVarLengthSigned();
            int sizecode = mc.readVarLengthUnsigned();
            boolean isReverse = (sizecode & 1) != 0;
            byte[] description = null;
            int descSize = sizecode >> 1;
            if (descSize > 0) {
                description = mc.readUnified(descSize, expCtxWay);
            }
            byte[] geometry = mc.readDataUntil(endPointer);
            if (linklon == this.ilon && linklat == this.ilat) continue;
            OsmLink link = this.getCompatibleLink(linklon, linklat, isReverse, 2);
            if (link == null) {
                OsmNode tn = hollowNodes.get(linklon, linklat);
                if (tn == null) {
                    tn = new OsmNode(linklon, linklat);
                    tn.setHollow();
                    hollowNodes.put(tn);
                }
                link = new OsmLink();
                link.targetNode = tn;
                link.counterLinkWritten = isReverse;
                link.state = 1;
                this.addLink(link);
            }
            if ((rlink = link.targetNode.getCompatibleLink(this.ilon, this.ilat, !isReverse, 1)) == null) {
                rlink = new OsmLink();
                rlink.targetNode = this;
                rlink.counterLinkWritten = !isReverse;
                rlink.state = (byte)2;
                link.targetNode.addLink(rlink);
            }
            if (isReverse) continue;
            link.descriptionBitmap = description;
            link.setGeometry(geometry);
            if (!rlink.counterLinkWritten) continue;
            rlink.descriptionBitmap = description;
            rlink.setGeometry(geometry);
        }
        hollowNodes.remove(this);
    }

    public final boolean isHollow() {
        return this.selev == -12345;
    }

    public final void setHollow() {
        this.selev = (short)-12345;
    }

    @Override
    public final long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public final void unlinkLink(OsmLink link) {
        if (link == this.firstlink) {
            this.firstlink = link.next;
            return;
        }
        OsmLink l = this.firstlink;
        while (l != null) {
            if (l.next == link) {
                l.next = link.next;
                return;
            }
            l = l.next;
        }
    }

    public final boolean equals(Object o) {
        if (o instanceof OsmNode) {
            OsmNode n = (OsmNode)o;
            return n.ilon == this.ilon && n.ilat == this.ilat;
        }
        return false;
    }

    public final int hashCode() {
        return this.ilon + this.ilat;
    }
}

