/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

public final class ReducedMedianFilter {
    private int nsamples;
    private double[] weights;
    private int[] values;

    public ReducedMedianFilter(int size) {
        this.weights = new double[size];
        this.values = new int[size];
    }

    public void reset() {
        this.nsamples = 0;
    }

    public void addSample(double weight, int value) {
        if (weight > 0.0) {
            this.weights[this.nsamples] = weight;
            this.values[this.nsamples] = value;
            ++this.nsamples;
        }
    }

    public double calcEdgeReducedMedian(double fraction) {
        this.removeEdgeWeight((1.0 - fraction) / 2.0, true);
        this.removeEdgeWeight((1.0 - fraction) / 2.0, false);
        double totalWeight = 0.0;
        double totalValue = 0.0;
        for (int i = 0; i < this.nsamples; ++i) {
            double w = this.weights[i];
            totalWeight += w;
            totalValue += w * (double)this.values[i];
        }
        return totalValue / totalWeight;
    }

    private void removeEdgeWeight(double excessWeight, boolean high) {
        while (excessWeight > 0.0) {
            int i;
            double totalWeight = 0.0;
            int minmax = 0;
            for (i = 0; i < this.nsamples; ++i) {
                double w = this.weights[i];
                if (!(w > 0.0)) continue;
                int v = this.values[i];
                if (totalWeight == 0.0 || (high ? v > minmax : v < minmax)) {
                    minmax = v;
                }
                totalWeight += w;
            }
            if (totalWeight < excessWeight) {
                throw new IllegalArgumentException("ups, not enough weight to remove");
            }
            for (i = 0; i < this.nsamples; ++i) {
                if (this.values[i] != minmax || !(this.weights[i] > 0.0)) continue;
                if (excessWeight > this.weights[i]) {
                    excessWeight -= this.weights[i];
                    this.weights[i] = 0.0;
                    continue;
                }
                int n = i;
                this.weights[n] = this.weights[n] - excessWeight;
                excessWeight = 0.0;
            }
        }
    }
}

