/*
 * Decompiled with CFR 0.152.
 */
package btools.server;

import btools.router.OsmNodeNamed;
import btools.router.OsmTrack;
import btools.router.RoutingContext;
import btools.router.RoutingEngine;
import btools.server.ServiceContext;
import btools.server.request.ProfileUploadHandler;
import btools.server.request.RequestHandler;
import btools.server.request.ServerHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class RouteServer
extends Thread {
    public static final String PROFILE_UPLOAD_URL = "/brouter/profile";
    public ServiceContext serviceContext;
    private Socket clientSocket = null;
    private RoutingEngine cr = null;
    private volatile boolean terminated;
    private static DateFormat tsFormat = new SimpleDateFormat("dd.MM.yy HH:mm", new Locale("en", "US"));

    public void stopRouter() {
        RoutingEngine e = this.cr;
        if (e != null) {
            e.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formattedTimestamp() {
        DateFormat dateFormat = tsFormat;
        synchronized (dateFormat) {
            return tsFormat.format(new Date(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream(), "UTF-8"));
            bw = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream(), "UTF-8"));
            String getline = br.readLine();
            if (getline == null || getline.startsWith("GET /favicon.ico")) {
                return;
            }
            InetAddress ip = this.clientSocket.getInetAddress();
            System.out.println(RouteServer.formattedTimestamp() + " ip=" + (ip == null ? "null" : ip.toString()) + " -> " + getline);
            String url = getline.split(" ")[1];
            HashMap<String, String> params = RouteServer.getUrlParams(url);
            long maxRunningTime = RouteServer.getMaxRunningTime();
            if (!params.containsKey("lonlats") || !params.containsKey("profile")) {
                if (url.startsWith(PROFILE_UPLOAD_URL)) {
                    if (getline.startsWith("OPTIONS")) {
                        String corsHeaders = "Access-Control-Allow-Methods: GET, POST\nAccess-Control-Allow-Headers: Content-Type\n";
                        RouteServer.writeHttpHeader(bw, "text/plain", null, corsHeaders);
                        bw.flush();
                        return;
                    }
                    RouteServer.writeHttpHeader(bw, "application/json");
                    String profileId = null;
                    if (url.length() > PROFILE_UPLOAD_URL.length() + 1) {
                        profileId = url.substring(PROFILE_UPLOAD_URL.length() + 1);
                    }
                    ProfileUploadHandler uploadHandler = new ProfileUploadHandler(this.serviceContext);
                    uploadHandler.handlePostRequest(profileId, br, bw);
                    bw.flush();
                    return;
                }
                throw new IllegalArgumentException("unknown request syntax: " + getline);
            }
            ServerHandler handler = new ServerHandler(this.serviceContext, params);
            RoutingContext rc = ((RequestHandler)handler).readRoutingContext();
            List<OsmNodeNamed> wplist = ((RequestHandler)handler).readWayPointList();
            this.cr = new RoutingEngine(null, null, this.serviceContext.segmentDir, wplist, rc);
            this.cr.quite = true;
            this.cr.doRun(maxRunningTime);
            if (this.cr.getErrorMessage() != null) {
                RouteServer.writeHttpHeader(bw);
                bw.write(this.cr.getErrorMessage());
                bw.write("\n");
            } else {
                OsmTrack track = this.cr.getFoundTrack();
                RouteServer.writeHttpHeader(bw, ((RequestHandler)handler).getMimeType(), ((RequestHandler)handler).getFileName());
                if (track != null) {
                    bw.write(((RequestHandler)handler).formatTrack(track));
                }
            }
            bw.flush();
        }
        catch (Throwable e) {
            System.out.println("RouteServer got exception (will continue): " + e);
            e.printStackTrace();
        }
        finally {
            this.cr = null;
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {}
            }
            if (this.clientSocket != null) {
                try {
                    this.clientSocket.close();
                }
                catch (Exception e) {}
            }
            this.terminated = true;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("BRouter 1.4.3 / 06082016");
        if (args.length != 5) {
            System.out.println("serve BRouter protocol");
            System.out.println("usage: java RouteServer <segmentdir> <profiledir> <customprofiledir> <port> <maxthreads>");
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.segmentDir = args[0];
        serviceContext.profileDir = args[1];
        System.setProperty("profileBaseDir", serviceContext.profileDir);
        serviceContext.customProfileDir = args[2];
        int maxthreads = Integer.parseInt(args[4]);
        TreeMap<Long, RouteServer> threadMap = new TreeMap<Long, RouteServer>();
        ServerSocket serverSocket = new ServerSocket(Integer.parseInt(args[3]));
        long last_ts = 0L;
        while (true) {
            long ts;
            boolean removedItem;
            Socket clientSocket = serverSocket.accept();
            RouteServer server = new RouteServer();
            server.serviceContext = serviceContext;
            server.clientSocket = clientSocket;
            block1: do {
                removedItem = false;
                for (Map.Entry e : threadMap.entrySet()) {
                    if (!((RouteServer)e.getValue()).terminated) continue;
                    threadMap.remove(e.getKey());
                    removedItem = true;
                    continue block1;
                }
            } while (removedItem);
            if (threadMap.size() >= maxthreads) {
                Long k = (Long)threadMap.firstKey();
                RouteServer victim = (RouteServer)threadMap.get(k);
                threadMap.remove(k);
                victim.stopRouter();
            }
            for (ts = System.currentTimeMillis(); ts <= last_ts; ++ts) {
            }
            threadMap.put(ts, server);
            last_ts = ts;
            server.start();
        }
    }

    private static HashMap<String, String> getUrlParams(String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringTokenizer tk = new StringTokenizer(url, "?&");
        while (tk.hasMoreTokens()) {
            String t = tk.nextToken();
            StringTokenizer tk2 = new StringTokenizer(t, "=");
            if (!tk2.hasMoreTokens()) continue;
            String key = tk2.nextToken();
            if (!tk2.hasMoreTokens()) continue;
            String value = tk2.nextToken();
            params.put(key, value);
        }
        return params;
    }

    private static long getMaxRunningTime() {
        long maxRunningTime = 60000L;
        String sMaxRunningTime = System.getProperty("maxRunningTime");
        if (sMaxRunningTime != null) {
            maxRunningTime = Integer.parseInt(sMaxRunningTime) * 1000;
        }
        return maxRunningTime;
    }

    private static void writeHttpHeader(BufferedWriter bw) throws IOException {
        RouteServer.writeHttpHeader(bw, "text/plain");
    }

    private static void writeHttpHeader(BufferedWriter bw, String mimeType) throws IOException {
        RouteServer.writeHttpHeader(bw, mimeType, null);
    }

    private static void writeHttpHeader(BufferedWriter bw, String mimeType, String fileName) throws IOException {
        RouteServer.writeHttpHeader(bw, mimeType, fileName, null);
    }

    private static void writeHttpHeader(BufferedWriter bw, String mimeType, String fileName, String headers) throws IOException {
        bw.write("HTTP/1.1 200 OK\n");
        bw.write("Connection: close\n");
        bw.write("Content-Type: " + mimeType + "; charset=utf-8\n");
        if (fileName != null) {
            bw.write("Content-Disposition: attachment; filename=" + fileName + "\n");
        }
        bw.write("Access-Control-Allow-Origin: *\n");
        if (headers != null) {
            bw.write(headers);
        }
        bw.write("\n");
    }
}

