/*
 * Decompiled with CFR 0.152.
 */
package btools.server;

import btools.mapaccess.OsmNode;
import btools.router.OsmNodeNamed;
import btools.router.RoutingContext;
import btools.router.RoutingEngine;
import btools.router.SearchBoundary;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;

public class BRouter {
    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            try {
                int maxKm;
                String queryString = args[1];
                int sepIdx = queryString.indexOf(61);
                if (sepIdx >= 0) {
                    queryString = queryString.substring(sepIdx + 1);
                }
                queryString = URLDecoder.decode(queryString, "ISO-8859-1");
                int ntokens = 1;
                for (int ic = 0; ic < queryString.length(); ++ic) {
                    if (queryString.charAt(ic) != '_') continue;
                    ++ntokens;
                }
                String[] a2 = new String[ntokens + 1];
                int idx = 1;
                int pos = 0;
                while (true) {
                    int p;
                    if ((p = queryString.indexOf(95, pos)) < 0) break;
                    a2[idx++] = queryString.substring(pos, p);
                    pos = p + 1;
                }
                a2[idx++] = queryString.substring(pos);
                System.out.println("Content-type: text/plain");
                System.out.println();
                OsmNodeNamed from = BRouter.readPosition(a2, 1, "from");
                OsmNodeNamed to = BRouter.readPosition(a2, 3, "to");
                int airDistance = from.calcDistance(to);
                String airDistanceLimit = System.getProperty("airDistanceLimit");
                if (airDistanceLimit != null && airDistance > (maxKm = Integer.parseInt(airDistanceLimit)) * 1000) {
                    System.out.println("airDistance " + airDistance / 1000 + "km exceeds limit for online router (" + maxKm + "km)");
                    return;
                }
                long maxRunningTime = 60000L;
                String sMaxRunningTime = System.getProperty("maxRunningTime");
                if (sMaxRunningTime != null) {
                    maxRunningTime = Integer.parseInt(sMaxRunningTime) * 1000;
                }
                ArrayList<OsmNodeNamed> wplist = new ArrayList<OsmNodeNamed>();
                wplist.add(from);
                wplist.add(to);
                RoutingEngine re = new RoutingEngine(null, null, args[0], wplist, BRouter.readRoutingContext(a2));
                re.doRun(maxRunningTime);
                if (re.getErrorMessage() != null) {
                    System.out.println(re.getErrorMessage());
                }
            }
            catch (Throwable e) {
                System.out.println("unexpected exception: " + e);
            }
            System.exit(0);
        }
        System.out.println("BRouter 1.4.3 / 06082016 / abrensch");
        if (args.length < 6) {
            System.out.println("Find routes in an OSM map");
            System.out.println("usage: java -jar brouter.jar <segmentdir> <lon-from> <lat-from> <lon-to> <lat-to> <profile>");
            return;
        }
        ArrayList<OsmNodeNamed> wplist = new ArrayList<OsmNodeNamed>();
        wplist.add(BRouter.readPosition(args, 1, "from"));
        RoutingEngine re = null;
        if ("seed".equals(args[3])) {
            int searchRadius = Integer.parseInt(args[4]);
            String filename = SearchBoundary.getFileName((OsmNode)wplist.get(0));
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream("traffic/" + filename)));
            for (int direction = 0; direction < 8; ++direction) {
                RoutingContext rc = BRouter.readRoutingContext(args);
                SearchBoundary boundary = new SearchBoundary((OsmNode)wplist.get(0), searchRadius, direction / 2);
                rc.trafficOutputStream = dos;
                rc.inverseDirection = (direction & 1) != 0;
                re = new RoutingEngine("mytrack", "mylog", args[0], wplist, rc);
                re.boundary = boundary;
                re.airDistanceCostFactor = rc.trafficDirectionFactor;
                re.doSearch();
                if (re.getErrorMessage() != null) break;
            }
            dos.close();
        } else {
            wplist.add(BRouter.readPosition(args, 3, "to"));
            re = new RoutingEngine("mytrack", "mylog", args[0], wplist, BRouter.readRoutingContext(args));
            re.doRun(0L);
        }
        if (re.getErrorMessage() != null) {
            System.out.println(re.getErrorMessage());
        }
    }

    private static OsmNodeNamed readPosition(String[] args, int idx, String name) {
        OsmNodeNamed n = new OsmNodeNamed();
        n.name = name;
        n.ilon = (int)((Double.parseDouble(args[idx]) + 180.0) * 1000000.0 + 0.5);
        n.ilat = (int)((Double.parseDouble(args[idx + 1]) + 90.0) * 1000000.0 + 0.5);
        return n;
    }

    private static RoutingContext readRoutingContext(String[] args) {
        RoutingContext c = new RoutingContext();
        if (args.length > 5) {
            c.localFunction = args[5];
            if (args.length > 6) {
                c.setAlternativeIdx(Integer.parseInt(args[6]));
            }
        }
        return c;
    }
}

