/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.router.MessageData;
import btools.router.VoiceHint;
import java.util.ArrayList;
import java.util.List;

public final class VoiceHintProcessor {
    private double catchingRange;
    private boolean explicitRoundabouts;

    public VoiceHintProcessor(double catchingRange, boolean explicitRoundabouts) {
        this.catchingRange = catchingRange;
        this.explicitRoundabouts = explicitRoundabouts;
    }

    private float sumNonConsumedWithinCatchingRange(List<VoiceHint> inputs, int offset) {
        VoiceHint input;
        float angle = 0.0f;
        for (double distance = 0.0; offset >= 0 && distance < this.catchingRange; distance += (double)input.goodWay.linkdist) {
            input = inputs.get(offset--);
            if (input.turnAngleConsumed) break;
            angle += input.goodWay.turnangle;
            input.turnAngleConsumed = true;
        }
        return angle;
    }

    public List<VoiceHint> process(List<VoiceHint> inputs) {
        ArrayList<VoiceHint> results = new ArrayList<VoiceHint>();
        double distance = 0.0;
        float roundAboutTurnAngle = 0.0f;
        int roundaboutExit = 0;
        for (int hintIdx = 0; hintIdx < inputs.size(); ++hintIdx) {
            boolean conditionalTrigger;
            boolean isLink2Highway;
            VoiceHint input = inputs.get(hintIdx);
            float turnAngle = input.goodWay.turnangle;
            distance += (double)input.goodWay.linkdist;
            int currentPrio = input.goodWay.getPrio();
            int oldPrio = input.oldWay.getPrio();
            int minPrio = Math.min(oldPrio, currentPrio);
            boolean bl = isLink2Highway = input.oldWay.isLinktType() && !input.goodWay.isLinktType();
            if (input.oldWay.isRoundabout()) {
                boolean isExit;
                roundAboutTurnAngle += this.sumNonConsumedWithinCatchingRange(inputs, hintIdx);
                boolean bl2 = isExit = roundaboutExit == 0;
                if (input.badWays != null) {
                    for (MessageData badWay : input.badWays) {
                        if (badWay.isBadOneway() || !badWay.isGoodForCars() || !((double)Math.abs(badWay.turnangle) < 120.0)) continue;
                        isExit = true;
                    }
                }
                if (!isExit) continue;
                ++roundaboutExit;
                continue;
            }
            if (roundaboutExit > 0) {
                input.angle = roundAboutTurnAngle += this.sumNonConsumedWithinCatchingRange(inputs, hintIdx);
                input.distanceToNext = distance;
                input.roundaboutExit = turnAngle < 0.0f ? -roundaboutExit : roundaboutExit;
                distance = 0.0;
                results.add(input);
                roundAboutTurnAngle = 0.0f;
                roundaboutExit = 0;
                continue;
            }
            int maxPrioAll = -1;
            int maxPrioCandidates = -1;
            float maxAngle = -180.0f;
            float minAngle = 180.0f;
            float minAbsAngeRaw = 180.0f;
            if (input.badWays != null) {
                for (MessageData badWay : input.badWays) {
                    boolean isHighway2Link;
                    int badPrio = badWay.getPrio();
                    float badTurn = badWay.turnangle;
                    boolean bl3 = isHighway2Link = !input.oldWay.isLinktType() && badWay.isLinktType();
                    if (badPrio > maxPrioAll && !isHighway2Link) {
                        maxPrioAll = badPrio;
                    }
                    if (badWay.costfactor < 20.0f && Math.abs(badTurn) < minAbsAngeRaw) {
                        minAbsAngeRaw = Math.abs(badTurn);
                    }
                    if (badPrio < minPrio || badWay.isBadOneway() || Math.abs(badTurn) - Math.abs(turnAngle) > 80.0f) continue;
                    if (badPrio > maxPrioCandidates) {
                        maxPrioCandidates = badPrio;
                    }
                    if (badTurn > maxAngle) {
                        maxAngle = badTurn;
                    }
                    if (!(badTurn < minAngle)) continue;
                    minAngle = badTurn;
                }
            }
            boolean hasSomethingMoreStraight = (double)(Math.abs(turnAngle) - minAbsAngeRaw) > 20.0;
            boolean unconditionalTrigger = hasSomethingMoreStraight || maxPrioAll > minPrio && !isLink2Highway || maxPrioCandidates > currentPrio;
            boolean bl4 = conditionalTrigger = maxPrioCandidates >= minPrio;
            if (unconditionalTrigger || conditionalTrigger) {
                input.angle = turnAngle;
                input.calcCommand();
                boolean isStraight = input.cmd == 1;
                boolean bl5 = input.needsRealTurn = !unconditionalTrigger && isStraight;
                if (maxAngle < turnAngle) {
                    float f = turnAngle > 0.0f ? turnAngle : 0.0f;
                    if (maxAngle > turnAngle - 45.0f - f) {
                        input.cmd = 9;
                    }
                }
                if (minAngle > turnAngle) {
                    float f = turnAngle < 0.0f ? turnAngle : 0.0f;
                    if (minAngle < turnAngle + 45.0f - f) {
                        input.cmd = 8;
                    }
                }
                input.angle = this.sumNonConsumedWithinCatchingRange(inputs, hintIdx);
                input.distanceToNext = distance;
                distance = 0.0;
                results.add(input);
            }
            if (results.size() <= 0 || !(distance < this.catchingRange)) continue;
            ((VoiceHint)results.get((int)(results.size() - 1))).angle += this.sumNonConsumedWithinCatchingRange(inputs, hintIdx);
        }
        ArrayList<VoiceHint> results2 = new ArrayList<VoiceHint>();
        int i = results.size();
        while (i > 0) {
            VoiceHint hint = (VoiceHint)results.get(--i);
            if (hint.cmd == 0) {
                hint.calcCommand();
            }
            if (hint.needsRealTurn && hint.cmd == 1) continue;
            double dist = hint.distanceToNext;
            while (dist < this.catchingRange && i > 0) {
                VoiceHint h2 = (VoiceHint)results.get(i - 1);
                dist = h2.distanceToNext;
                hint.distanceToNext += dist;
                hint.angle += h2.angle;
                --i;
                if (!h2.isRoundabout()) continue;
                h2.angle = hint.angle;
                hint = h2;
                break;
            }
            if (!this.explicitRoundabouts) {
                hint.roundaboutExit = 0;
            }
            hint.calcCommand();
            results2.add(hint);
        }
        return results2;
    }
}

