/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import btools.expressions.BExpressionContext;
import btools.mapaccess.OsmPos;
import btools.memrouter.GraphLoader;
import btools.memrouter.OsmLinkP;
import btools.memrouter.ScheduledRouter;
import btools.router.OsmNodeNamed;
import btools.router.RoutingContext;
import btools.router.RoutingEngine;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TwinRoutingEngine
extends RoutingEngine {
    private static Object graphSync = new Object();
    private static GraphLoader graph;
    private static Map<String, BExpressionContext[]> expressionCache;

    public TwinRoutingEngine(String outfileBase, String logfileBase, String segmentDir, List<OsmNodeNamed> waypoints, RoutingContext rc) {
        super(outfileBase, logfileBase, segmentDir, waypoints, rc);
    }

    @Override
    public void doRun(long maxRunningTime) {
        if (this.routingContext.localFunction != null && this.routingContext.localFunction.startsWith("../im/")) {
            this.doMemoryRun(maxRunningTime);
        } else {
            super.doRun(maxRunningTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMemoryRun(long maxRunningTime) {
        try {
            Object object = graphSync;
            synchronized (object) {
                if (graph == null) {
                    this.loadGraph();
                }
                ++OsmLinkP.currentserial;
                ScheduledRouter router = new ScheduledRouter(graph, this.routingContext, this);
                this.foundTrack = router.findRoute((OsmPos)this.waypoints.get(0), (OsmPos)this.waypoints.get(1), this.routingContext.getAlternativeIdx(-1, 10));
                System.out.println("linksProcessed=" + router.linksProcessed + " linksReProcessed=" + router.linksReProcessed);
                System.out.println("skippedChained=" + router.skippedChained + " closedSkippedChained=" + router.closedSkippedChained);
                System.out.println("expCtxWay: requests: " + this.routingContext.expctxWay.requests + " requests2: " + this.routingContext.expctxWay.requests2 + " cache-misses: " + this.routingContext.expctxWay.cachemisses);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMessage = e.getMessage();
        }
    }

    private void loadGraph() throws Exception {
        File parentDir = new File(this.segmentDir).getParentFile();
        File nodeTilesIn = new File(parentDir, "unodes55");
        File wayTilesIn = new File(parentDir, "waytiles55");
        File[] fahrplanFiles = new File[]{new File(parentDir, "fahrplan_nahverkehr.txt"), new File(parentDir, "fahrplan_dbfern.txt")};
        graph = new GraphLoader();
        graph.process(nodeTilesIn, wayTilesIn, fahrplanFiles, this.routingContext.expctxWay);
    }

    static {
        expressionCache = new HashMap<String, BExpressionContext[]>();
    }
}

