/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import btools.expressions.BExpressionContextWay;
import btools.expressions.BExpressionMetaData;
import btools.mapaccess.OsmPos;
import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeIterator;
import btools.mapcreator.WayData;
import btools.mapcreator.WayIterator;
import btools.memrouter.OsmLinkP;
import btools.memrouter.OsmNodeP;
import btools.memrouter.OsmNodePT;
import btools.memrouter.ScheduleParser;
import btools.memrouter.StationNode;
import btools.util.ByteArrayUnifier;
import btools.util.CompactLongMap;
import btools.util.FrozenLongMap;
import btools.util.LazyArrayOfLists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GraphLoader
extends MapCreatorBase {
    private CompactLongMap<OsmNodeP> nodesMap;
    private Map<String, StationNode> stationMap;
    private BExpressionContextWay expctxWay;
    private ByteArrayUnifier abUnifier;
    private int currentTile;
    private long linksLoaded = 0L;
    private long nodesLoaded = 0L;
    private static final int MAXTILES = 2592;
    private List<LazyArrayOfLists<OsmNodeP>> seglistsArray = new ArrayList<LazyArrayOfLists<OsmNodeP>>(2592);

    public static void main(String[] args) throws Exception {
        System.out.println("*** GraphLoader: load a routing graph in memory");
        if (args.length != 5) {
            System.out.println("usage: java GraphLoader <node-tiles-in> <way-tiles-in> <lookup-file> <profile-file> <fahtplan-file>");
            return;
        }
        BExpressionMetaData meta = new BExpressionMetaData();
        BExpressionContextWay expctxWay = new BExpressionContextWay(meta);
        File lookupFile = new File(args[2]);
        File profileFile = new File(args[3]);
        meta.readMetaData(lookupFile);
        expctxWay.parseFile(profileFile, "global");
        GraphLoader graph = new GraphLoader();
        File[] fahrplanFiles = new File[]{new File(args[4]), new File(args[5])};
        graph.process(new File(args[0]), new File(args[1]), fahrplanFiles, expctxWay);
    }

    public void process(File nodeTilesIn, File wayTilesIn, File[] fahrplanFiles, BExpressionContextWay expctxWay) throws Exception {
        int i;
        this.expctxWay = expctxWay;
        this.seglistsArray = new ArrayList<LazyArrayOfLists<OsmNodeP>>(2592);
        for (i = 0; i < 2592; ++i) {
            this.seglistsArray.add(null);
        }
        this.abUnifier = new ByteArrayUnifier(16384, false);
        this.nodesMap = new CompactLongMap();
        new NodeIterator(this, false).processDir(nodeTilesIn, ".u5d");
        this.nodesMap = new FrozenLongMap<OsmNodeP>(this.nodesMap);
        for (i = 0; i < 2592; ++i) {
            if (this.seglistsArray.get(i) == null) continue;
            this.seglistsArray.get(i).trimAll();
        }
        new WayIterator(this, false).processDir(wayTilesIn, ".wt5");
        this.nodesMap = null;
        System.out.println("nodesLoaded=" + this.nodesLoaded + " linksLoaded=" + this.linksLoaded);
        this.stationMap = ScheduleParser.parseTrainTable(fahrplanFiles, this, expctxWay);
        System.gc();
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("memory after graph loading: " + mem / 1024L / 1024L + " MB");
    }

    public OsmNodeP matchNodeForPosition(OsmPos pos, BExpressionContextWay wayCtx, boolean transitonly) {
        if (transitonly) {
            return this.matchStationForPosition(pos);
        }
        int ilon = pos.getILon();
        int ilat = pos.getILat();
        ArrayList<OsmNodeP> nodes = new ArrayList<OsmNodeP>();
        nodes.addAll(this.subListForPos(ilon - 6125, ilat - 6125));
        nodes.addAll(this.subListForPos(ilon - 6125, ilat + 6125));
        nodes.addAll(this.subListForPos(ilon + 6125, ilat - 6125));
        nodes.addAll(this.subListForPos(ilon + 6125, ilat + 6125));
        int mindist = Integer.MAX_VALUE;
        OsmNodeP bestmatch = null;
        for (OsmNodeP node : nodes) {
            if (transitonly) {
                int dist;
                StationNode sn = this.getStationNode(node);
                if (sn == null || (dist = pos.calcDistance(sn)) >= mindist) continue;
                mindist = dist;
                bestmatch = sn;
                continue;
            }
            int dist = pos.calcDistance(node);
            if (dist >= mindist || wayCtx != null && !this.hasRoutableLinks(node, wayCtx)) continue;
            mindist = dist;
            bestmatch = node;
        }
        return bestmatch;
    }

    private StationNode getStationNode(OsmNodeP node) {
        for (OsmLinkP link = node.getFirstLink(); link != null; link = link.getNext(node)) {
            OsmNodeP tn = link.getTarget(node);
            if (!(tn instanceof StationNode)) continue;
            return (StationNode)tn;
        }
        return null;
    }

    public OsmNodeP matchStationForPosition(OsmPos pos) {
        int mindist = Integer.MAX_VALUE;
        StationNode bestmatch = null;
        for (StationNode node : this.stationMap.values()) {
            int dist = pos.calcDistance(node);
            if (dist >= mindist) continue;
            mindist = dist;
            bestmatch = node;
        }
        return bestmatch;
    }

    private boolean hasRoutableLinks(OsmNodeP node, BExpressionContextWay wayCtx) {
        for (OsmLinkP link = node.getFirstLink(); link != null; link = link.getNext(node)) {
            if (!link.isWayLink()) continue;
            wayCtx.evaluate(false, link.descriptionBitmap, null);
            if (!(wayCtx.getCostfactor() < 10000.0f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void nodeFileStart(File nodefile) throws Exception {
        this.currentTile = this.tileForFilename(nodefile.getName());
        this.seglistsArray.set(this.currentTile, new LazyArrayOfLists(160000));
        System.out.println("nodes currentTile=" + this.currentTile);
    }

    @Override
    public void nextNode(NodeData data) throws Exception {
        OsmNodeP n = data.description == null ? new OsmNodeP() : new OsmNodePT(data.description);
        n.ilon = data.ilon;
        n.ilat = data.ilat;
        n.selev = data.selev;
        this.nodesMap.fastPut(data.nid, n);
        this.subListForPos(n.ilon, n.ilat).add(n);
        ++this.nodesLoaded;
    }

    @Override
    public boolean wayFileStart(File wayfile) throws Exception {
        this.currentTile = this.tileForFilename(wayfile.getName());
        System.out.println("ways currentTile=" + this.currentTile);
        return true;
    }

    @Override
    public void nextWay(WayData way) throws Exception {
        byte[] description = this.abUnifier.unify(way.description);
        byte wayBits = 0;
        this.expctxWay.decode(description);
        if (!this.expctxWay.getBooleanLookupValue("bridge")) {
            wayBits = (byte)(wayBits | 1);
        }
        if (!this.expctxWay.getBooleanLookupValue("tunnel")) {
            wayBits = (byte)(wayBits | 2);
        }
        OsmNodeP n1 = null;
        OsmNodeP n2 = null;
        for (int i = 0; i < way.nodes.size(); ++i) {
            long nid = way.nodes.get(i);
            n1 = n2;
            n2 = this.nodesMap.get(nid);
            if (n1 != null && n2 != null && n1 != n2 && this.tileForPos(n1.ilon, n1.ilat) == this.currentTile) {
                OsmLinkP link = n2.createLink(n1);
                link.descriptionBitmap = description;
                ++this.linksLoaded;
            }
            if (n2 == null) continue;
            n2.wayBits = (byte)(n2.wayBits | wayBits);
        }
    }

    private int tileForFilename(String filename) {
        int ilat;
        int ilon;
        String basename = filename.substring(0, filename.length() - 4);
        String uname = basename.toUpperCase();
        int idx = uname.indexOf("_");
        if (idx < 0) {
            return -1;
        }
        String slon = uname.substring(0, idx);
        String slat = uname.substring(idx + 1);
        int n = slon.charAt(0) == 'W' ? -Integer.valueOf(slon.substring(1)).intValue() : (ilon = slon.charAt(0) == 'E' ? Integer.valueOf(slon.substring(1)) : -1);
        int n2 = slat.charAt(0) == 'S' ? -Integer.valueOf(slat.substring(1)).intValue() : (ilat = slat.charAt(0) == 'N' ? Integer.valueOf(slat.substring(1)) : -1);
        if (ilon < -180 || ilon >= 180 || ilon % 5 != 0) {
            return -1;
        }
        if (ilat < -90 || ilat >= 90 || ilat % 5 != 0) {
            return -1;
        }
        return (ilon + 180) / 5 + 72 * ((ilat + 90) / 5);
    }

    private int tileForPos(int ilon, int ilat) {
        return ilon / 5000000 + 72 * (ilat / 5000000);
    }

    private int subIdxForPos(int ilon, int ilat) {
        int lonModulo = ilon % 5000000;
        int latModulo = ilat % 5000000;
        return lonModulo / 12500 + 400 * (latModulo / 12500);
    }

    private List<OsmNodeP> subListForPos(int ilon, int ilat) {
        if (ilon < 0 || ilon >= 360000000 || ilat < 0 || ilat >= 180000000) {
            throw new IllegalArgumentException("illegal position: " + ilon + " " + ilat);
        }
        int tileNr = this.tileForPos(ilon, ilat);
        if (this.seglistsArray.get(tileNr) == null) {
            return new ArrayList<OsmNodeP>();
        }
        return this.seglistsArray.get(tileNr).getList(this.subIdxForPos(ilon, ilat));
    }
}

