/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.WayData;
import btools.mapcreator.WayListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;

public class WayIterator
extends MapCreatorBase {
    private WayListener listener;
    private boolean delete;

    public WayIterator(WayListener wayListener, boolean deleteAfterReading) {
        this.listener = wayListener;
        this.delete = deleteAfterReading;
    }

    public void processDir(File indir, String inSuffix) throws Exception {
        if (!indir.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + indir);
        }
        File[] af = WayIterator.sortBySizeAsc(indir.listFiles());
        for (int i = 0; i < af.length; ++i) {
            File wayfile = af[i];
            if (!wayfile.getName().endsWith(inSuffix)) continue;
            this.processFile(wayfile);
        }
    }

    public void processFile(File wayfile) throws Exception {
        System.out.println("*** WayIterator reading: " + wayfile);
        if (!this.listener.wayFileStart(wayfile)) {
            return;
        }
        DataInputStream di = new DataInputStream(new BufferedInputStream(new FileInputStream(wayfile)));
        try {
            while (true) {
                WayData w = new WayData(di);
                this.listener.nextWay(w);
            }
        }
        catch (EOFException eof) {
            di.close();
            this.listener.wayFileEnd(wayfile);
            if (this.delete && "true".equals(System.getProperty("deletetmpfiles"))) {
                wayfile.delete();
            }
            return;
        }
    }
}

