/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class MixCoderDataInputStream
extends DataInputStream {
    private long lastValue;
    private long repCount;

    public MixCoderDataInputStream(InputStream is) {
        super(is);
    }

    public long readSigned() throws IOException {
        long v = this.readUnsigned();
        return (v & 1L) == 0L ? v >> 1 : -(v >> 1);
    }

    public long readUnsigned() throws IOException {
        long v = 0L;
        int shift = 0;
        while (true) {
            long i7 = this.readByte() & 0xFF;
            v |= (i7 & 0x7FL) << shift;
            if ((i7 & 0x80L) == 0L) break;
            shift += 7;
        }
        return v;
    }

    public long readMixed() throws IOException {
        if (this.repCount == 0L) {
            long b = this.readByte() & 0xFF;
            long repCode = b >> 6;
            long diffcode = b & 0x3FL;
            this.repCount = repCode == 0L ? this.readUnsigned() : repCode;
            this.lastValue += diffcode == 0L ? this.readSigned() : diffcode - 32L;
        }
        --this.repCount;
        return this.lastValue;
    }
}

