/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.util.ByteDataReader;
import btools.util.ByteDataWriter;

public final class OsmTransferNode {
    public byte[] descriptionBitmap;
    public OsmTransferNode next;
    public int ilon;
    public int ilat;
    public short selev;
    private static final int BIT_DESC = 1;
    private static final int BIT_ILONHIGH = 2;
    private static final int BIT_ILATHIGH = 4;
    private static final int BIT_STOP = 8;

    public static byte[] encode(OsmTransferNode tn) {
        byte[] currentDesc = null;
        int currentILonHigh = 0;
        int currentILatHigh = 0;
        OsmTransferNode n = tn;
        int size = 1;
        while (n != null) {
            if (n.descriptionBitmap == null) {
                throw new IllegalArgumentException("transfernode-encode: description is null");
            }
            if (n.descriptionBitmap != currentDesc) {
                currentDesc = n.descriptionBitmap;
                size += 1 + currentDesc.length;
            }
            if (n.ilon >> 16 != currentILonHigh) {
                size += 2;
                currentILonHigh = n.ilon >> 16;
            }
            if (n.ilat >> 16 != currentILatHigh) {
                size += 2;
                currentILatHigh = n.ilat >> 16;
            }
            size += 7;
            n = n.next;
        }
        byte[] ab = new byte[size];
        ByteDataWriter os = new ByteDataWriter(ab);
        currentDesc = null;
        currentILonHigh = 0;
        currentILatHigh = 0;
        n = tn;
        while (n != null) {
            int mode = 0;
            if (n.descriptionBitmap != currentDesc) {
                mode |= 1;
                currentDesc = n.descriptionBitmap;
            }
            if (n.ilon >> 16 != currentILonHigh) {
                mode |= 2;
                currentILonHigh = n.ilon >> 16;
            }
            if (n.ilat >> 16 != currentILatHigh) {
                mode |= 4;
                currentILatHigh = n.ilat >> 16;
            }
            os.writeByte(mode);
            if ((mode & 1) != 0) {
                os.writeByte(currentDesc.length);
                os.write(currentDesc);
            }
            if ((mode & 2) != 0) {
                os.writeShort(currentILonHigh);
            }
            if ((mode & 4) != 0) {
                os.writeShort(currentILatHigh);
            }
            os.writeShort(n.ilon);
            os.writeShort(n.ilat);
            os.writeShort(n.selev);
            n = n.next;
        }
        os.writeByte(8);
        return ab;
    }

    public static OsmTransferNode decode(byte[] ab) {
        byte mode;
        ByteDataReader is = new ByteDataReader(ab);
        OsmTransferNode firstNode = null;
        OsmTransferNode lastNode = null;
        byte[] currentDesc = null;
        short currentILonHigh = 0;
        short currentILatHigh = 0;
        while (((mode = is.readByte()) & 8) == 0) {
            OsmTransferNode n = new OsmTransferNode();
            if ((mode & 1) != 0) {
                byte dlen = is.readByte();
                currentDesc = new byte[dlen];
                is.readFully(currentDesc);
            }
            if ((mode & 2) != 0) {
                currentILonHigh = is.readShort();
            }
            if ((mode & 4) != 0) {
                currentILatHigh = is.readShort();
            }
            n.descriptionBitmap = currentDesc;
            if (n.descriptionBitmap == null) {
                throw new IllegalArgumentException("transfernode-decode: description is null");
            }
            int ilon = is.readShort() & 0xFFFF;
            int ilat = is.readShort() & 0xFFFF;
            n.ilon = ilon |= currentILonHigh << 16;
            n.ilat = ilat |= currentILatHigh << 16;
            n.selev = is.readShort();
            if (ilon != n.ilon) {
                System.out.println("ilon=" + ilon + " n.ilon=" + n.ilon);
            }
            if (ilat != n.ilat) {
                System.out.println("ilat=" + ilat + " n.ilat=" + n.ilat);
            }
            if (lastNode != null) {
                lastNode.next = n;
            } else {
                firstNode = n;
            }
            lastNode = n;
        }
        return firstNode;
    }
}

