/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.ByteDataWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class Raster2Png
extends ByteDataWriter {
    public static final int FILTER_NONE = 0;
    protected static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    protected static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    protected static final byte[] IEND = new byte[]{73, 69, 78, 68};
    protected int width;
    protected int height;
    protected int[] imagePixels;
    protected CRC32 crc = new CRC32();

    public Raster2Png() {
        super(null);
    }

    public byte[] pngEncode(int width, int height, int[] imagePixels) throws IOException {
        this.width = width;
        this.height = height;
        this.imagePixels = imagePixels;
        this.ab = new byte[(width + 1) * height * 3 + 200];
        byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.write(pngIdBytes);
        this.writeHeader();
        this.writeImageData();
        return this.toByteArray();
    }

    protected void writeHeader() {
        this.writeInt(13);
        int startPos = this.aboffset;
        this.write(IHDR);
        this.writeInt(this.width);
        this.writeInt(this.height);
        this.writeByte(8);
        this.writeByte(2);
        this.writeByte(0);
        this.writeByte(0);
        this.writeByte(0);
        this.crc.reset();
        this.crc.update(this.ab, startPos, this.aboffset - startPos);
        this.writeInt((int)this.crc.getValue());
    }

    protected void writeImageData() throws IOException {
        int nRows;
        int startRow = 0;
        int bytesPerPixel = 3;
        Deflater scrunch = new Deflater(6);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream(1024);
        DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, scrunch);
        for (int rowsLeft = this.height; rowsLeft > 0; rowsLeft -= nRows) {
            nRows = Math.min(Short.MAX_VALUE / (this.width * (bytesPerPixel + 1)), rowsLeft);
            nRows = Math.max(nRows, 1);
            int[] pixels = new int[this.width * nRows];
            this.getPixels(startRow, nRows, pixels);
            byte[] scanLines = new byte[this.width * nRows * bytesPerPixel + nRows];
            int scanPos = 0;
            for (int i = 0; i < this.width * nRows; ++i) {
                if (i % this.width == 0) {
                    scanLines[scanPos++] = 0;
                }
                scanLines[scanPos++] = (byte)(pixels[i] >> 16 & 0xFF);
                scanLines[scanPos++] = (byte)(pixels[i] >> 8 & 0xFF);
                scanLines[scanPos++] = (byte)(pixels[i] & 0xFF);
            }
            compBytes.write(scanLines, 0, scanPos);
            startRow += nRows;
        }
        compBytes.close();
        byte[] compressedLines = outBytes.toByteArray();
        int nCompressed = compressedLines.length;
        this.crc.reset();
        this.writeInt(nCompressed);
        this.write(IDAT);
        this.crc.update(IDAT);
        this.write(compressedLines);
        this.crc.update(compressedLines, 0, nCompressed);
        this.writeInt((int)this.crc.getValue());
        scrunch.finish();
        this.writeInt(0);
        this.write(IEND);
        this.crc.reset();
        this.crc.update(IEND);
        this.writeInt((int)this.crc.getValue());
    }

    private void getPixels(int startRow, int nRows, int[] pixels) {
        for (int i = 0; i < nRows; ++i) {
            int ir = i + startRow;
            for (int ic = 0; ic < this.width; ++ic) {
                pixels[i * this.width + ic] = this.imagePixels[ir * this.width + ic];
            }
        }
    }
}

