/*
 * Decompiled with CFR 0.152.
 */
package btools.server;

import btools.server.NearRecentWps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SuspectManager
extends Thread {
    private static String formatAge(File f) {
        long age = System.currentTimeMillis() - f.lastModified();
        long minutes = age / 60000L;
        if (minutes < 60L) {
            return minutes + " minutes";
        }
        long hours = minutes / 60L;
        if (hours < 24L) {
            return hours + " hours";
        }
        long days = hours / 24L;
        return days + " days";
    }

    private static String getLevelDecsription(int level) {
        switch (level) {
            case 30: {
                return "motorway";
            }
            case 28: {
                return "trunk";
            }
            case 26: {
                return "primary";
            }
            case 24: {
                return "secondary";
            }
            case 22: {
                return "tertiary";
            }
        }
        return "none";
    }

    public static void process(String url, BufferedWriter bw) throws IOException {
        bw.write("<html><body>\n");
        StringTokenizer tk = new StringTokenizer(url, "/");
        tk.nextToken();
        tk.nextToken();
        long id = 0L;
        String country = null;
        if (tk.hasMoreTokens()) {
            String ctry = tk.nextToken();
            if (new File("suspects/suspects_" + ctry + ".txt").exists()) {
                country = ctry;
            }
        }
        if (country == null) {
            File[] files = new File("suspects").listFiles();
            TreeSet<String> names = new TreeSet<String>();
            for (File f : files) {
                String name = f.getName();
                if (!name.startsWith("suspects_") || !name.endsWith(".txt")) continue;
                names.add(name.substring(9, name.length() - 4));
            }
            for (String ctry : names) {
                String url2 = "/brouter/suspects/" + ctry;
                bw.write("<a href=\"" + url2 + "\">" + ctry + "</a><br>\n");
            }
            bw.write("</body></html>\n");
            bw.flush();
            return;
        }
        boolean showWatchList = false;
        if (tk.hasMoreTokens()) {
            String t = tk.nextToken();
            if ("watchlist".equals(t)) {
                showWatchList = true;
            } else {
                id = Long.parseLong(t);
            }
        }
        if (showWatchList) {
            File suspects = new File("suspects/suspects_" + country + ".txt");
            bw.write("watchlist for " + country + "\n");
            bw.write("<br><a href=\"/brouter/suspects\">back to country list</a><br><br>\n");
            if (suspects.exists()) {
                String line;
                BufferedReader r = new BufferedReader(new FileReader(suspects));
                while ((line = r.readLine()) != null) {
                    long age;
                    StringTokenizer tk2 = new StringTokenizer(line);
                    id = Long.parseLong(tk2.nextToken());
                    String countryId = country + "/" + id;
                    if (new File("falsepositives/" + id).exists()) continue;
                    File fixedEntry = new File("fixedsuspects/" + id);
                    File confirmedEntry = new File("confirmednegatives/" + id);
                    if (!fixedEntry.exists() || !confirmedEntry.exists() || (age = System.currentTimeMillis() - confirmedEntry.lastModified()) / 1000L < 691200L) continue;
                    String hint = "&nbsp;&nbsp;&nbsp;confirmed " + SuspectManager.formatAge(confirmedEntry) + " ago";
                    int ilon = (int)(id >> 32);
                    int ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
                    double dlon = (double)(ilon - 180000000) / 1000000.0;
                    double dlat = (double)(ilat - 90000000) / 1000000.0;
                    String url2 = "/brouter/suspects/" + countryId;
                    bw.write("<a href=\"" + url2 + "\">" + dlon + "," + dlat + "</a>" + hint + "<br>\n");
                }
                r.close();
            }
            bw.write("</body></html>\n");
            bw.flush();
            return;
        }
        String message = null;
        if (tk.hasMoreTokens()) {
            int wps;
            String command = tk.nextToken();
            if ("falsepositive".equals(command)) {
                wps = NearRecentWps.count(id);
                if (wps < 8) {
                    message = "marking false-positive requires at least 10 recent nearby waypoints from BRouter-Web, found: " + wps;
                } else {
                    new File("falsepositives/" + id).createNewFile();
                    id = 0L;
                }
            }
            if ("confirm".equals(command)) {
                wps = NearRecentWps.count(id);
                if (wps < 2) {
                    message = "marking confirmed requires at least 2 recent nearby waypoints from BRouter-Web, found: " + wps;
                } else {
                    new File("confirmednegatives/" + id).createNewFile();
                }
            }
            if ("fixed".equals(command)) {
                new File("fixedsuspects/" + id).createNewFile();
                id = 0L;
            }
        }
        if (id != 0L) {
            String countryId = country + "/" + id;
            int ilon = (int)(id >> 32);
            int ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
            double dlon = (double)(ilon - 180000000) / 1000000.0;
            double dlat = (double)(ilat - 90000000) / 1000000.0;
            String url1 = "http://brouter.de/brouter-web/#zoom=18&lat=" + dlat + "&lon=" + dlon + "&layer=OpenStreetMap&lonlats=" + dlon + "," + dlat + "&profile=car-eco-de";
            String url2 = "https://www.openstreetmap.org/?mlat=" + dlat + "&mlon=" + dlon + "#map=19/" + dlat + "/" + dlon + "&layers=N";
            double slon = 0.00156;
            double slat = 0.001;
            String url3 = "http://osmose.openstreetmap.fr/de/josm_proxy?load_and_zoom?left=" + (dlon - slon) + "&bottom=" + (dlat - slat) + "&right=" + (dlon + slon) + "&top=" + (dlat + slat);
            if (message != null) {
                bw.write("<strong>" + message + "</strong><br><br>\n");
            }
            bw.write("<a href=\"" + url1 + "\">Open in BRouter-Web</a><br><br>\n");
            bw.write("<a href=\"" + url2 + "\">Open in OpenStreetmap</a><br><br>\n");
            bw.write("<a href=\"" + url3 + "\">Open in JOSM (via remote control)</a><br><br>\n");
            File fixedEntry = new File("fixedsuspects/" + id);
            if (fixedEntry.exists()) {
                bw.write("<br><br><a href=\"/brouter/suspects/" + country + "/watchlist\">back to watchlist</a><br><br>\n");
            } else {
                bw.write("<a href=\"/brouter/suspects/" + countryId + "/falsepositive\">mark false positive (=not an issue)</a><br><br>\n");
                File confirmedEntry = new File("confirmednegatives/" + id);
                if (confirmedEntry.exists()) {
                    bw.write("<a href=\"/brouter/suspects/" + countryId + "/fixed\">mark as fixed</a><br><br>\n");
                } else {
                    bw.write("<a href=\"/brouter/suspects/" + countryId + "/confirm\">mark as a confirmed issue</a><br><br>\n");
                }
                bw.write("<br><br><a href=\"/brouter/suspects/" + country + "\">back to issue list</a><br><br>\n");
            }
        } else {
            File suspects = new File("suspects/suspects_" + country + ".txt");
            bw.write("suspect list for " + country + "\n");
            bw.write("<br><a href=\"/brouter/suspects/" + country + "/watchlist\">see watchlist</a>\n");
            bw.write("<br><a href=\"/brouter/suspects\">back to country list</a><br><br>\n");
            if (suspects.exists()) {
                int maxprio = 0;
                for (int pass = 1; pass <= 2; ++pass) {
                    String line;
                    if (pass == 2) {
                        bw.write("current level: " + SuspectManager.getLevelDecsription(maxprio) + "<br><br>\n");
                    }
                    BufferedReader r = new BufferedReader(new FileReader(suspects));
                    while ((line = r.readLine()) != null) {
                        StringTokenizer tk2 = new StringTokenizer(line);
                        id = Long.parseLong(tk2.nextToken());
                        int prio = Integer.parseInt(tk2.nextToken());
                        prio = (prio + 1) / 2 * 2;
                        String countryId = country + "/" + id;
                        String hint = "";
                        if (new File("falsepositives/" + id).exists() || new File("fixedsuspects/" + id).exists()) continue;
                        if (pass == 1) {
                            if (prio <= maxprio) continue;
                            maxprio = prio;
                            continue;
                        }
                        if (prio < maxprio) continue;
                        File confirmedEntry = new File("confirmednegatives/" + id);
                        if (confirmedEntry.exists()) {
                            hint = "&nbsp;&nbsp;&nbsp;confirmed " + SuspectManager.formatAge(confirmedEntry) + " ago";
                        }
                        int ilon = (int)(id >> 32);
                        int ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
                        double dlon = (double)(ilon - 180000000) / 1000000.0;
                        double dlat = (double)(ilat - 90000000) / 1000000.0;
                        String url2 = "/brouter/suspects/" + countryId;
                        bw.write("<a href=\"" + url2 + "\">" + dlon + "," + dlat + "</a>" + hint + "<br>\n");
                    }
                    r.close();
                }
            }
        }
        bw.write("</body></html>\n");
        bw.flush();
    }
}

