/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmTransferNode;
import btools.mapaccess.TurnRestriction;
import btools.router.MessageData;
import btools.router.OsmPath;
import btools.router.OsmPathElement;
import btools.router.OsmTrack;
import btools.router.RoutingContext;

final class StdPath
extends OsmPath {
    private int ehbd;
    private int ehbu;

    StdPath() {
    }

    @Override
    public void init(OsmPath orig) {
        StdPath origin = (StdPath)orig;
        this.ehbd = origin.ehbd;
        this.ehbu = origin.ehbu;
    }

    @Override
    protected void resetState() {
        this.ehbd = 0;
        this.ehbu = 0;
    }

    @Override
    protected double processWaySection(RoutingContext rc, double distance, double delta_h, double elevation, double angle, double cosangle, boolean isStartpoint, int nsection, int lastpriorityclassifier) {
        float turncostbase = rc.expctxWay.getTurncost();
        float cfup = rc.expctxWay.getUphillCostfactor();
        float cfdown = rc.expctxWay.getDownhillCostfactor();
        float cf = rc.expctxWay.getCostfactor();
        cfup = cfup == 0.0f ? cf : cfup;
        cfdown = cfdown == 0.0f ? cf : cfdown;
        int dist = (int)distance;
        int turncost = (int)((1.0 - cosangle) * (double)turncostbase + 0.2);
        if (this.message != null) {
            this.message.linkturncost += turncost;
            this.message.turnangle = (float)angle;
        }
        double sectionCost = turncost;
        int delta_h_micros = (int)(1000000.0 * delta_h);
        this.ehbd += -delta_h_micros - dist * rc.downhillcutoff;
        this.ehbu += delta_h_micros - dist * rc.uphillcutoff;
        float downweight = 0.0f;
        if (this.ehbd > rc.elevationpenaltybuffer) {
            downweight = 1.0f;
            int reduce = dist * rc.elevationbufferreduce;
            int excess = this.ehbd - rc.elevationpenaltybuffer;
            if (reduce > excess) {
                downweight = (float)excess / (float)reduce;
                reduce = excess;
            }
            if (reduce < (excess = this.ehbd - rc.elevationmaxbuffer)) {
                reduce = excess;
            }
            this.ehbd -= reduce;
            if (rc.downhillcostdiv > 0) {
                int elevationCost = reduce / rc.downhillcostdiv;
                sectionCost += (double)elevationCost;
                if (this.message != null) {
                    this.message.linkelevationcost += elevationCost;
                }
            }
        } else if (this.ehbd < 0) {
            this.ehbd = 0;
        }
        float upweight = 0.0f;
        if (this.ehbu > rc.elevationpenaltybuffer) {
            upweight = 1.0f;
            int reduce = dist * rc.elevationbufferreduce;
            int excess = this.ehbu - rc.elevationpenaltybuffer;
            if (reduce > excess) {
                upweight = (float)excess / (float)reduce;
                reduce = excess;
            }
            if (reduce < (excess = this.ehbu - rc.elevationmaxbuffer)) {
                reduce = excess;
            }
            this.ehbu -= reduce;
            if (rc.uphillcostdiv > 0) {
                int elevationCost = reduce / rc.uphillcostdiv;
                sectionCost += (double)elevationCost;
                if (this.message != null) {
                    this.message.linkelevationcost += elevationCost;
                }
            }
        } else if (this.ehbu < 0) {
            this.ehbu = 0;
        }
        float costfactor = cfup * upweight + cf * (1.0f - upweight - downweight) + cfdown * downweight;
        if (this.message != null) {
            this.message.costfactor = costfactor;
        }
        return sectionCost += (double)((float)dist * costfactor + 0.5f);
    }

    @Override
    protected double processTargetNode(RoutingContext rc) {
        if (this.targetNode.nodeDescription != null) {
            boolean nodeAccessGranted = (double)rc.expctxWay.getNodeAccessGranted() != 0.0;
            rc.expctxNode.evaluate(nodeAccessGranted, this.targetNode.nodeDescription);
            float initialcost = rc.expctxNode.getInitialcost();
            if ((double)initialcost >= 1000000.0) {
                return -1.0;
            }
            if (this.message != null) {
                this.message.linknodecost += (int)initialcost;
                this.message.nodeKeyValues = rc.expctxNode.getKeyValueDescription(nodeAccessGranted, this.targetNode.nodeDescription);
            }
            return initialcost;
        }
        return 0.0;
    }

    protected void xxxaddAddionalPenalty(OsmTrack refTrack, boolean detailMode, OsmPath origin, OsmLink link, RoutingContext rc) {
        short ele2;
        float classifierDiff;
        byte[] description = link.descriptionBitmap;
        if (description == null) {
            throw new IllegalArgumentException("null description for: " + link);
        }
        boolean recordTransferNodes = detailMode || rc.countTraffic;
        boolean recordMessageData = detailMode;
        rc.nogomatch = false;
        int lon0 = origin.originLon;
        int lat0 = origin.originLat;
        OsmNode p1 = this.sourceNode;
        int lon1 = p1.getILon();
        int lat1 = p1.getILat();
        short ele1 = origin.selev;
        int linkdisttotal = 0;
        MessageData msgData = recordMessageData ? new MessageData() : null;
        boolean isReverse = link.isReverse(this.sourceNode);
        rc.expctxWay.evaluate(rc.inverseDirection ^ isReverse, description);
        boolean isTrafficBackbone = this.cost == 0 && rc.expctxWay.getIsTrafficBackbone() > 0.0f;
        float turncostbase = rc.expctxWay.getTurncost();
        float cfup = rc.expctxWay.getUphillCostfactor();
        float cfdown = rc.expctxWay.getDownhillCostfactor();
        float cf = rc.expctxWay.getCostfactor();
        cfup = cfup == 0.0f ? cf : cfup;
        cfdown = cfdown == 0.0f ? cf : cfdown;
        float newClassifier = rc.expctxWay.getInitialClassifier();
        if ((double)newClassifier == 0.0) {
            newClassifier = (cfup + cfdown + cf) / 3.0f;
        }
        if ((double)(classifierDiff = newClassifier - this.lastClassifier) > 5.0E-4 || (double)classifierDiff < -5.0E-4) {
            this.lastClassifier = newClassifier;
            float initialcost = rc.expctxWay.getInitialcost();
            int iicost = (int)initialcost;
            if (recordMessageData) {
                msgData.linkinitcost += iicost;
            }
            this.cost += iicost;
        }
        OsmTransferNode transferNode = link.geometry == null ? null : rc.geometryDecoder.decodeGeometry(link.geometry, p1, this.targetNode, isReverse);
        boolean isFirstSection = true;
        while (true) {
            int lat2;
            int lon2;
            this.originLon = lon1;
            this.originLat = lat1;
            if (transferNode == null) {
                lon2 = this.targetNode.ilon;
                lat2 = this.targetNode.ilat;
                ele2 = this.targetNode.selev;
            } else {
                lon2 = transferNode.ilon;
                lat2 = transferNode.ilat;
                ele2 = transferNode.selev;
            }
            boolean checkTRs = false;
            if (isFirstSection) {
                isFirstSection = false;
                boolean bl = checkTRs = rc.considerTurnRestrictions && !rc.inverseDirection && !detailMode;
            }
            if (checkTRs) {
                boolean hasAnyPositive = false;
                boolean hasPositive = false;
                boolean hasNegative = false;
                TurnRestriction tr = this.sourceNode.firstRestriction;
                while (tr != null) {
                    boolean trValid;
                    boolean bl = trValid = !tr.exceptBikes() || !rc.bikeMode;
                    if (trValid && tr.fromLon == lon0 && tr.fromLat == lat0) {
                        if (tr.isPositive) {
                            hasAnyPositive = true;
                        }
                        if (tr.toLon == lon2 && tr.toLat == lat2) {
                            if (tr.isPositive) {
                                hasPositive = true;
                            } else {
                                hasNegative = true;
                            }
                        }
                    }
                    tr = tr.next;
                }
                if (!hasPositive && (hasAnyPositive || hasNegative)) {
                    this.cost = -1;
                    return;
                }
            }
            if (recordMessageData && msgData.wayKeyValues != null) {
                this.originElement.message = msgData;
                msgData = new MessageData();
            }
            int dist = rc.calcDistance(lon1, lat1, lon2, lat2);
            boolean stopAtEndpoint = false;
            if (rc.shortestmatch) {
                if (rc.isEndpoint) {
                    stopAtEndpoint = true;
                    ele2 = this.interpolateEle(ele1, ele2, rc.wayfraction);
                } else {
                    this.cost = 0;
                    this.ehbd = 0;
                    this.ehbu = 0;
                    lon0 = -1;
                    lat0 = -1;
                    if (recordTransferNodes) {
                        if (rc.wayfraction > 0.0) {
                            ele1 = this.interpolateEle(ele1, ele2, 1.0 - rc.wayfraction);
                            this.originElement = OsmPathElement.create(rc.ilonshortest, rc.ilatshortest, ele1, null, rc.countTraffic);
                        } else {
                            this.originElement = null;
                        }
                    }
                }
            }
            if (recordMessageData) {
                msgData.linkdist += dist;
            }
            linkdisttotal += dist;
            if (lon0 == -1 && lat0 == -1) {
                double coslat = Math.cos((double)(lat1 - 90000000) * 1.234134E-8);
                if (rc.startDirectionValid && coslat > 0.0) {
                    double dir = (double)rc.startDirection.intValue() / 57.29578;
                    lon0 = lon1 - (int)(1000.0 * Math.sin(dir) / coslat);
                    lat0 = lat1 - (int)(1000.0 * Math.cos(dir));
                }
            }
            if (!isTrafficBackbone && lon0 != -1 && lat0 != -1) {
                double angle = rc.calcAngle(lon0, lat0, lon1, lat1, lon2, lat2);
                double cos = 1.0 - rc.getCosAngle();
                int actualturncost = (int)(cos * (double)turncostbase + 0.2);
                this.cost += actualturncost;
                if (recordMessageData) {
                    msgData.linkturncost += actualturncost;
                    msgData.turnangle = (float)rc.calcAngle(lon0, lat0, lon1, lat1, lon2, lat2);
                }
            }
            int elefactor = 250000;
            if (ele2 == Short.MIN_VALUE) {
                ele2 = ele1;
            }
            if (ele1 != Short.MIN_VALUE) {
                this.ehbd += (ele1 - ele2) * elefactor - dist * rc.downhillcutoff;
                this.ehbu += (ele2 - ele1) * elefactor - dist * rc.uphillcutoff;
            }
            float downweight = 0.0f;
            if (this.ehbd > rc.elevationpenaltybuffer) {
                downweight = 1.0f;
                int reduce = dist * rc.elevationbufferreduce;
                int excess = this.ehbd - rc.elevationpenaltybuffer;
                if (reduce > excess) {
                    downweight = (float)excess / (float)reduce;
                    reduce = excess;
                }
                if (reduce < (excess = this.ehbd - rc.elevationmaxbuffer)) {
                    reduce = excess;
                }
                this.ehbd -= reduce;
                if (rc.downhillcostdiv > 0) {
                    int elevationCost = reduce / rc.downhillcostdiv;
                    this.cost += elevationCost;
                    if (recordMessageData) {
                        msgData.linkelevationcost += elevationCost;
                    }
                }
            } else if (this.ehbd < 0) {
                this.ehbd = 0;
            }
            float upweight = 0.0f;
            if (this.ehbu > rc.elevationpenaltybuffer) {
                upweight = 1.0f;
                int reduce = dist * rc.elevationbufferreduce;
                int excess = this.ehbu - rc.elevationpenaltybuffer;
                if (reduce > excess) {
                    upweight = (float)excess / (float)reduce;
                    reduce = excess;
                }
                if (reduce < (excess = this.ehbu - rc.elevationmaxbuffer)) {
                    reduce = excess;
                }
                this.ehbu -= reduce;
                if (rc.uphillcostdiv > 0) {
                    int elevationCost = reduce / rc.uphillcostdiv;
                    this.cost += elevationCost;
                    if (recordMessageData) {
                        msgData.linkelevationcost += elevationCost;
                    }
                }
            } else if (this.ehbu < 0) {
                this.ehbu = 0;
            }
            float costfactor = cfup * upweight + cf * (1.0f - upweight - downweight) + cfdown * downweight;
            if (isTrafficBackbone) {
                costfactor = 0.0f;
            }
            float fcost = (float)dist * costfactor + 0.5f;
            if ((double)costfactor > 9998.0 && !detailMode || (double)(fcost + (float)this.cost) >= 2.0E9) {
                this.cost = -1;
                return;
            }
            int waycost = (int)fcost;
            this.cost += waycost;
            if (rc.countTraffic) {
                int minDist = (int)rc.trafficSourceMinDist;
                int cost2 = this.cost < minDist ? minDist : this.cost;
                this.traffic = (float)((double)this.traffic + (double)((float)dist * rc.expctxWay.getTrafficSourceDensity()) * Math.pow((float)cost2 / 10000.0f, rc.trafficSourceExponent));
            }
            if (recordMessageData) {
                msgData.costfactor = costfactor;
                msgData.priorityclassifier = (int)rc.expctxWay.getPriorityClassifier();
                msgData.classifiermask = (int)rc.expctxWay.getClassifierMask();
                msgData.lon = lon2;
                msgData.lat = lat2;
                msgData.ele = ele2;
                msgData.wayKeyValues = rc.expctxWay.getKeyValueDescription(isReverse, description);
            }
            if (stopAtEndpoint) {
                if (recordTransferNodes) {
                    this.originElement = OsmPathElement.create(rc.ilonshortest, rc.ilatshortest, ele2, this.originElement, rc.countTraffic);
                    this.originElement.cost = this.cost;
                    if (recordMessageData) {
                        this.originElement.message = msgData;
                    }
                }
                if (rc.nogomatch) {
                    this.cost = -1;
                }
                return;
            }
            if (transferNode == null) {
                if (refTrack != null && refTrack.containsNode(this.targetNode) && refTrack.containsNode(this.sourceNode)) {
                    int reftrackcost = linkdisttotal;
                    this.cost += reftrackcost;
                }
                break;
            }
            transferNode = transferNode.next;
            if (recordTransferNodes) {
                this.originElement = OsmPathElement.create(lon2, lat2, ele2, this.originElement, rc.countTraffic);
                this.originElement.cost = this.cost;
                this.originElement.addTraffic(this.traffic);
                this.traffic = 0.0f;
            }
            lon0 = lon1;
            lat0 = lat1;
            lon1 = lon2;
            lat1 = lat2;
            ele1 = ele2;
        }
        this.selev = ele2;
        if (rc.nogomatch) {
            this.cost = -1;
            return;
        }
        if (this.targetNode.nodeDescription != null) {
            boolean nodeAccessGranted = (double)rc.expctxWay.getNodeAccessGranted() != 0.0;
            rc.expctxNode.evaluate(nodeAccessGranted, this.targetNode.nodeDescription);
            float initialcost = rc.expctxNode.getInitialcost();
            if ((double)initialcost >= 1000000.0) {
                this.cost = -1;
                return;
            }
            int iicost = (int)initialcost;
            this.cost += iicost;
            if (recordMessageData) {
                msgData.linknodecost += iicost;
                msgData.nodeKeyValues = rc.expctxNode.getKeyValueDescription(nodeAccessGranted, this.targetNode.nodeDescription);
            }
        }
        if (recordMessageData) {
            this.message = msgData;
        }
    }

    @Override
    public int elevationCorrection(RoutingContext rc) {
        return (rc.downhillcostdiv > 0 ? this.ehbd / rc.downhillcostdiv : 0) + (rc.uphillcostdiv > 0 ? this.ehbu / rc.uphillcostdiv : 0);
    }

    @Override
    public boolean definitlyWorseThan(OsmPath path, RoutingContext rc) {
        int delta;
        StdPath p = (StdPath)path;
        int c = p.cost;
        if (rc.downhillcostdiv > 0 && (delta = p.ehbd - this.ehbd) > 0) {
            c += delta / rc.downhillcostdiv;
        }
        if (rc.uphillcostdiv > 0 && (delta = p.ehbu - this.ehbu) > 0) {
            c += delta / rc.uphillcostdiv;
        }
        return this.cost > c;
    }
}

