/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.router.OsmNodeNamed;
import java.util.ArrayList;
import java.util.List;

public class OsmNogoPolygon
extends OsmNodeNamed {
    public final List<Point> points = new ArrayList<Point>();
    public final boolean isClosed;

    public OsmNogoPolygon(boolean closed) {
        this.isClosed = closed;
        this.isNogo = true;
        this.name = "";
    }

    public final void addVertex(int lon, int lat) {
        this.points.add(new Point(lon, lat));
    }

    private static final double coslat(double lat) {
        double l = (lat - 9.0E7) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        return 1.0 - l2 + l4 / 6.0;
    }

    public void calcBoundingCircle() {
        int cymin = Integer.MAX_VALUE;
        int cxmin = Integer.MAX_VALUE;
        int cymax = Integer.MIN_VALUE;
        int cxmax = Integer.MIN_VALUE;
        for (int i = 0; i < this.points.size(); ++i) {
            Point p = this.points.get(i);
            if (p.x < cxmin) {
                cxmin = p.x;
            } else if (p.x > cxmax) {
                cxmax = p.x;
            }
            if (p.y < cymin) {
                cymin = p.y;
                continue;
            }
            if (p.y <= cymax) continue;
            cymax = p.y;
        }
        double cx = (double)(cxmax + cxmin) / 2.0;
        double cy = (double)(cymax + cymin) / 2.0;
        double ccoslat = OsmNogoPolygon.coslat(cy);
        double rad = 0.0;
        double rad2 = 0.0;
        double dpx = 0.0;
        double dpy = 0.0;
        double dmax2 = 0.0;
        int i_max = -1;
        while (true) {
            for (int i = 0; i < this.points.size(); ++i) {
                Point p = this.points.get(i);
                double dpix = ((double)p.x - cx) * ccoslat;
                double dpiy = (double)p.y - cy;
                double dist2 = dpix * dpix + dpiy * dpiy;
                if (dist2 <= rad2 || !(dist2 > dmax2)) continue;
                dmax2 = dist2;
                dpx = dpix;
                dpy = dpiy;
                i_max = i;
            }
            if (i_max < 0) break;
            double dist = Math.sqrt(dmax2);
            double dd = 0.5 * (dist - rad) / dist;
            ccoslat = OsmNogoPolygon.coslat(cy += dd * dpy);
            Point p = this.points.get(i_max);
            double dpix = ((double)p.x - (cx += dd * dpx)) * ccoslat;
            double dpiy = (double)p.y - cy;
            dmax2 = rad2 = dpix * dpix + dpiy * dpiy;
            rad = Math.sqrt(rad2);
            i_max = -1;
        }
        this.ilon = (int)Math.round(cx);
        this.ilat = (int)Math.round(cy);
        dpx = cx - (double)this.ilon;
        dpy = cy - (double)this.ilat;
        this.radius = (rad + Math.sqrt(dpx * dpx + dpy * dpy)) * 1.0E-6;
    }

    public boolean intersects(int lon0, int lat0, int lon1, int lat1) {
        int i;
        Point p0 = new Point(lon0, lat0);
        Point p1 = new Point(lon1, lat1);
        int i_last = this.points.size() - 1;
        Point p2 = this.points.get(this.isClosed ? i_last : 0);
        int n = i = this.isClosed ? 0 : 1;
        while (i <= i_last) {
            Point p3 = this.points.get(i);
            if (OsmNogoPolygon.intersect2D_2Segments(p0, p1, p2, p3) > 0) {
                return true;
            }
            p2 = p3;
            ++i;
        }
        return false;
    }

    public boolean isOnPolyline(long px, long py) {
        int i_last = this.points.size() - 1;
        Point p1 = this.points.get(0);
        for (int i = 1; i <= i_last; ++i) {
            Point p2 = this.points.get(i);
            if (OsmNogoPolygon.isOnLine(px, py, p1.x, p1.y, p2.x, p2.y)) {
                return true;
            }
            p1 = p2;
        }
        return false;
    }

    public static boolean isOnLine(long px, long py, long p0x, long p0y, long p1x, long p1y) {
        double v10x = px - p0x;
        double v10y = py - p0y;
        double v12x = p1x - p0x;
        double v12y = p1y - p0y;
        if (v10x == 0.0) {
            if (v10y == 0.0) {
                return true;
            }
            if (v12x != 0.0) {
                return false;
            }
            return v12y / v10y >= 1.0;
        }
        if (v10y == 0.0) {
            if (v12y != 0.0) {
                return false;
            }
            return v12x / v10x >= 1.0;
        }
        double kx = v12x / v10x;
        if (kx < 1.0) {
            return false;
        }
        return kx == v12y / v10y;
    }

    public boolean isWithin(long px, long py) {
        int i;
        int wn = 0;
        int i_last = this.points.size() - 1;
        Point p0 = this.points.get(this.isClosed ? i_last : 0);
        long p0x = p0.x;
        long p0y = p0.y;
        int n = i = this.isClosed ? 0 : 1;
        while (i <= i_last) {
            Point p1 = this.points.get(i);
            long p1x = p1.x;
            long p1y = p1.y;
            if (OsmNogoPolygon.isOnLine(px, py, p0x, p0y, p1x, p1y)) {
                return true;
            }
            if (p0y <= py) {
                if (p1y > py && (p1x - p0x) * (py - p0y) - (px - p0x) * (p1y - p0y) > 0L) {
                    ++wn;
                }
            } else if (p1y <= py && (p1x - p0x) * (py - p0y) - (px - p0x) * (p1y - p0y) < 0L) {
                --wn;
            }
            p0x = p1x;
            p0y = p1y;
            ++i;
        }
        return wn != 0;
    }

    private static boolean inSegment(Point p, Point seg_p0, Point seg_p1) {
        int sp0x = seg_p0.x;
        int sp1x = seg_p1.x;
        if (sp0x != sp1x) {
            int px = p.x;
            if (sp0x <= px && px <= sp1x) {
                return true;
            }
            if (sp0x >= px && px >= sp1x) {
                return true;
            }
        } else {
            int sp0y = seg_p0.y;
            int sp1y = seg_p1.y;
            int py = p.y;
            if (sp0y <= py && py <= sp1y) {
                return true;
            }
            if (sp0y >= py && py >= sp1y) {
                return true;
            }
        }
        return false;
    }

    private static int intersect2D_2Segments(Point s1p0, Point s1p1, Point s2p0, Point s2p1) {
        long ux = s1p1.x - s1p0.x;
        long uy = s1p1.y - s1p0.y;
        long vx = s2p1.x - s2p0.x;
        long vy = s2p1.y - s2p0.y;
        long wx = s1p0.x - s2p0.x;
        long wy = s1p0.y - s2p0.y;
        double d = ux * vy - uy * vx;
        if (d == 0.0) {
            double t1;
            double t0;
            boolean dv;
            if (ux * wy - uy * wx != 0L || vx * wy - vy * wx != 0L) {
                return 0;
            }
            boolean du = ux == 0L && uy == 0L;
            boolean bl = dv = vx == 0L && vy == 0L;
            if (du && dv) {
                return wx == 0L && wy == 0L ? 0 : 1;
            }
            if (du) {
                return OsmNogoPolygon.inSegment(s1p0, s2p0, s2p1) ? 1 : 0;
            }
            if (dv) {
                return OsmNogoPolygon.inSegment(s2p0, s1p0, s1p1) ? 1 : 0;
            }
            int w2x = s1p1.x - s2p0.x;
            int w2y = s1p1.y - s2p0.y;
            if (vx != 0L) {
                t0 = wx / vx;
                t1 = (long)w2x / vx;
            } else {
                t0 = wy / vy;
                t1 = (long)w2y / vy;
            }
            if (t0 > t1) {
                double t = t0;
                t0 = t1;
                t1 = t;
            }
            if (t0 > 1.0 || t1 < 0.0) {
                return 0;
            }
            t0 = t0 < 0.0 ? 0.0 : t0;
            t1 = t1 > 1.0 ? 1.0 : t1;
            return t0 == t1 ? 1 : 2;
        }
        double sI = (double)(vx * wy - vy * wx) / d;
        if (sI < 0.0 || sI > 1.0) {
            return 0;
        }
        double tI = (double)(ux * wy - uy * wx) / d;
        return tI < 0.0 || tI > 1.0 ? 0 : 1;
    }

    public static final class Point {
        public final int y;
        public final int x;

        Point(int lon, int lat) {
            this.x = lon;
            this.y = lat;
        }
    }
}

