/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmTransferNode;
import btools.router.OsmPath;
import btools.router.OsmPrePath;
import btools.router.RoutingContext;

final class KinematicPrePath
extends OsmPrePath {
    public double angle;
    public int priorityclassifier;
    public int classifiermask;

    KinematicPrePath() {
    }

    @Override
    protected void initPrePath(OsmPath origin, RoutingContext rc) {
        int lat2;
        int lon2;
        OsmTransferNode transferNode;
        byte[] description = this.link.descriptionBitmap;
        if (description == null) {
            throw new IllegalArgumentException("null description for: " + this.link);
        }
        int lon0 = origin.originLon;
        int lat0 = origin.originLat;
        OsmNode p1 = this.sourceNode;
        int lon1 = p1.getILon();
        int lat1 = p1.getILat();
        boolean isReverse = this.link.isReverse(this.sourceNode);
        rc.expctxWay.evaluate(rc.inverseDirection ^ isReverse, description);
        OsmTransferNode osmTransferNode = transferNode = this.link.geometry == null ? null : rc.geometryDecoder.decodeGeometry(this.link.geometry, p1, this.targetNode, isReverse);
        if (transferNode == null) {
            lon2 = this.targetNode.ilon;
            lat2 = this.targetNode.ilat;
        } else {
            lon2 = transferNode.ilon;
            lat2 = transferNode.ilat;
        }
        int dist = rc.calcDistance(lon1, lat1, lon2, lat2);
        this.angle = rc.calcAngle(lon0, lat0, lon1, lat1, lon2, lat2);
        this.priorityclassifier = (int)rc.expctxWay.getPriorityClassifier();
        this.classifiermask = (int)rc.expctxWay.getClassifierMask();
    }
}

