/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import btools.mapaccess.OsmPos;
import btools.memrouter.OffsetSet;
import btools.memrouter.OsmLinkP;

public class OsmNodeP
extends OsmLinkP
implements Comparable<OsmNodeP>,
OsmPos {
    public int ilat;
    public int ilon;
    public short selev;
    public static final int NO_BRIDGE_BIT = 1;
    public static final int NO_TUNNEL_BIT = 2;
    public byte wayBits = 0;

    public OsmNodeP(double dlon, double dlat) {
        this.ilon = (int)(dlon * 1000000.0 + 1.8E8);
        this.ilat = (int)(dlat * 1000000.0 + 9.0E7);
    }

    public OsmNodeP() {
    }

    @Override
    public int getILat() {
        return this.ilat;
    }

    @Override
    public int getILon() {
        return this.ilon;
    }

    @Override
    public short getSElev() {
        return (this.wayBits & 1) == 0 || (this.wayBits & 2) == 0 ? (short)Short.MIN_VALUE : this.selev;
    }

    @Override
    public double getElev() {
        return (double)this.selev / 4.0;
    }

    public OsmLinkP createLink(OsmNodeP source) {
        if (this.sourceNode == null && this.targetNode == null) {
            this.sourceNode = source;
            this.targetNode = this;
            source.addLink(this);
            return this;
        }
        OsmLinkP link = new OsmLinkP(source, this);
        this.addLink(link);
        source.addLink(link);
        return link;
    }

    public void addLink(OsmLinkP link) {
        link.setNext(this.previous, this);
        this.previous = link;
    }

    public OsmLinkP getFirstLink() {
        return this.sourceNode == null && this.targetNode == null ? this.previous : this;
    }

    @Override
    public int calcDistance(OsmPos p) {
        double l = (double)(this.ilat - 90000000) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        double coslat = 1.0 - l2 + l4 / 6.0;
        double dlat = (double)(this.ilat - p.getILat()) / 1000000.0;
        double dlon = (double)(this.ilon - p.getILon()) / 1000000.0 * coslat;
        double d = Math.sqrt(dlat * dlat + dlon * dlon) * 110984.0;
        return (int)(d + 1.0);
    }

    @Override
    public long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public byte[] getNodeDecsription() {
        return null;
    }

    public String toString2() {
        return this.ilon - 180000000 + "_" + (this.ilat - 90000000) + "_" + this.selev / 4;
    }

    @Override
    public int compareTo(OsmNodeP n) {
        long id2;
        long id1 = this.getIdFromPos();
        if (id1 < (id2 = n.getIdFromPos())) {
            return -1;
        }
        if (id1 > id2) {
            return 1;
        }
        return 0;
    }

    public OffsetSet filterAndCloseNode(OffsetSet in, boolean modifyGate) {
        return in;
    }

    public String getName() {
        return "<waynode>";
    }
}

