/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.MapCreatorBase;
import btools.mapsplitter.NodeData;
import btools.mapsplitter.NodeIterator;
import btools.mapsplitter.RelationData;
import btools.mapsplitter.RelationIterator;
import btools.mapsplitter.WayData;
import btools.mapsplitter.WayIterator;
import btools.util.DenseLongMap;
import btools.util.TinyDenseLongMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TileSplitter
extends MapCreatorBase {
    private NodeData templateNode = new NodeData(0L, 0, 0);
    private DenseLongMap nodeIndexMap;
    private DenseLongMap bigWayMemberMap;
    private DenseLongMap wayIndexMap;
    private DenseLongMap bigRelMemberMap;
    private DenseLongMap relIndexMap;
    private Map<NodeData, NodeData> nodeMap;
    private List<NodeData> thisLevelNodes;
    private Map<Long, Integer> thisLevelNodesIndexes;
    private List<WayData> thisLevelWays;
    private Map<Long, Integer> thisLevelWaysIndexes;
    private int level;
    private int baseLon;
    private int baseLat;
    private int nodeCount = 0;
    private String typeSuffix;
    private boolean inPassLoop;
    private int pass;
    private File inTileDir;

    public static void main(String[] args) throws Exception {
        System.out.println("*** TileSplitter: cut tiles into 16 pieces");
        if (args.length != 1) {
            System.out.println("usage: java TileSplitter <tile-dir>");
            return;
        }
        new TileSplitter().process(new File(args[0]));
    }

    public void process(File tileDir) throws Exception {
        for (int level = 0; level < 12; level += 2) {
            this.process(tileDir, level);
        }
    }

    public void process(File tileDir, int level) throws Exception {
        System.out.println("processing level: " + level);
        this.inTileDir = new File(tileDir, "" + level);
        this.outTileDir = new File(tileDir, "" + (level + 2));
        this.outTileDir.mkdirs();
        this.level = level;
        this.inPassLoop = false;
        new NodeIterator(this).processDir(this.inTileDir, ".ntl");
    }

    @Override
    public void nodeFileStart(File nodeFile) throws Exception {
        if (!this.inPassLoop) {
            this.inPassLoop = true;
            this.pass = 1;
            new NodeIterator(this).processFile(nodeFile);
            this.pass = 2;
            new NodeIterator(this).processFile(nodeFile);
            this.pass = 3;
            new NodeIterator(this).processFile(nodeFile);
            this.pass = 4;
            this.inPassLoop = false;
        }
        System.out.println("nodeFileStart pass=" + this.pass);
        if (this.pass == 1) {
            this.getBaseTileFromName(nodeFile.getName());
            this.nodeIndexMap = Boolean.getBoolean("useDenseMaps") ? new DenseLongMap() : new TinyDenseLongMap();
        } else if (this.pass != 2) {
            if (this.pass == 3) {
                this.nodeMap = new HashMap<NodeData, NodeData>();
                this.thisLevelNodes = new ArrayList<NodeData>();
            } else {
                NodeData.sortByGeoId(this.thisLevelNodes);
                this.thisLevelNodesIndexes = new HashMap<Long, Integer>();
                int idx = 0;
                for (NodeData n : this.thisLevelNodes) {
                    this.thisLevelNodesIndexes.put(n.nid, idx++);
                }
                this.thisLevelNodes = null;
            }
        }
        this.typeSuffix = "ntl";
    }

    private void getBaseTileFromName(String name) {
        System.out.println("getBaseTileFromName: " + name);
        int idx1 = name.indexOf(95);
        int idx2 = name.indexOf(46);
        this.baseLon = Integer.parseInt(name.substring(0, idx1));
        this.baseLat = Integer.parseInt(name.substring(idx1 + 1, idx2));
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
        int tidx = this.getTileIndex(n);
        if (this.pass == 1) {
            ++this.nodeCount;
            this.nodeIndexMap.put(n.nid, tidx);
        } else if (this.pass != 2) {
            boolean usedHere;
            boolean bl = usedHere = this.bigWayMemberMap.getInt(n.nid) == 0;
            if (usedHere && n.zoom == -1) {
                n.zoom = this.level;
            }
            if (this.pass == 3) {
                if (n.zoom != -1) {
                    n.calcGeoId();
                    this.nodeMap.put(n, n);
                    if (n.zoom == this.level) {
                        this.thisLevelNodes.add(n);
                    }
                }
            } else {
                if (n.zoom == this.level) {
                    n.nativeIndex = this.thisLevelNodesIndexes.get(n.nid);
                }
                if (usedHere) {
                    n.writeTo(this.getOutStreamForTile(16));
                }
                n.writeTo(this.getOutStreamForTile(tidx));
            }
        }
    }

    @Override
    public void nodeFileEnd(File nodeFile) throws Exception {
        String relfilename;
        File relfile;
        String name;
        String wayfilename;
        File wayfile;
        System.out.println("nodeFileEnd pass=" + this.pass);
        this.closeTileOutStreams();
        File parentNodes = new File(this.outTileDir, this.getNameForTile(16));
        if (this.pass == 2) {
            DenseLongMap denseLongMap = this.bigWayMemberMap = Boolean.getBoolean("useDenseMaps") ? new DenseLongMap() : new TinyDenseLongMap();
        }
        if ((wayfile = new File(this.inTileDir, wayfilename = (name = nodeFile.getName()).substring(0, name.length() - 3) + "wtl")).exists()) {
            new WayIterator(this).processFile(wayfile);
        }
        if (this.pass == 1) {
            DenseLongMap denseLongMap = this.bigRelMemberMap = Boolean.getBoolean("useDenseMaps") ? new DenseLongMap() : new TinyDenseLongMap();
        }
        if ((relfile = new File(this.inTileDir, relfilename = name.substring(0, name.length() - 3) + "rtl")).exists()) {
            new RelationIterator(this).processFile(relfile);
        }
        if (this.pass == 4) {
            nodeFile.delete();
            if (parentNodes.exists()) {
                parentNodes.renameTo(nodeFile);
            } else if (this.nodeCount > 0) {
                nodeFile.createNewFile();
            }
        }
    }

    @Override
    public void wayFileStart(File wayFile) throws Exception {
        System.out.println("wayFileStart pass=" + this.pass);
        if (this.pass == 1) {
            this.wayIndexMap = Boolean.getBoolean("useDenseMaps") ? new DenseLongMap() : new TinyDenseLongMap();
        } else if (this.pass == 3) {
            this.thisLevelWays = new ArrayList<WayData>();
        } else if (this.pass == 4) {
            WayData.sortByStartNode(this.thisLevelWays);
            this.thisLevelWaysIndexes = new HashMap<Long, Integer>();
            int idx = 0;
            for (WayData w : this.thisLevelWays) {
                this.thisLevelWaysIndexes.put(w.wid, idx++);
            }
            this.thisLevelWays = null;
        }
        this.typeSuffix = "wtl";
    }

    @Override
    public void nextWay(WayData w) throws Exception {
        int widx = this.getTileIndex(w);
        if (widx == -1) {
            System.out.println("************ invalid way: " + w.wid);
            return;
        }
        if (this.pass == 1) {
            this.wayIndexMap.put(w.wid, widx);
        } else {
            boolean usedHere;
            boolean bl = usedHere = this.bigRelMemberMap.getInt(w.wid) == 0;
            if (usedHere || widx == 16) {
                if (w.zoom == -1) {
                    w.zoom = this.level;
                }
                if (this.pass == 2) {
                    int nnodes = w.nodes.size();
                    for (int i = 0; i < nnodes; ++i) {
                        this.bigWayMemberMap.put(w.nodes.get(i), 0);
                    }
                }
            }
            if (this.pass == 3 && w.zoom == this.level) {
                w.startNodeIdx = this.getLocaleIndexForNid(w.nodes.get(0));
                this.thisLevelWays.add(w);
            }
            if (this.pass == 4) {
                if (w.zoom == this.level) {
                    w.nativeIndex = this.thisLevelWaysIndexes.get(w.wid);
                }
                if (usedHere && widx != 16) {
                    w.writeTo(this.getOutStreamForTile(16));
                }
                w.writeTo(this.getOutStreamForTile(widx));
            }
        }
    }

    @Override
    public void wayFileEnd(File wayFile) throws Exception {
        System.out.println("wayFileEnd pass=" + this.pass);
        this.closeTileOutStreams();
        if (this.pass == 4) {
            wayFile.delete();
            File parentWays = new File(this.outTileDir, this.getNameForTile(16));
            if (parentWays.exists()) {
                parentWays.renameTo(wayFile);
            }
        }
    }

    @Override
    public void relationFileStart(File relFile) throws Exception {
        System.out.println("relFileStart pass=" + this.pass);
        if (this.pass == 1) {
            this.relIndexMap = Boolean.getBoolean("useDenseMaps") ? new DenseLongMap() : new TinyDenseLongMap();
        } else if (this.pass == 2) {
            // empty if block
        }
        this.typeSuffix = "rtl";
    }

    @Override
    public void nextRelation(RelationData r) throws Exception {
        int ridx = this.getTileIndex(r);
        if (ridx == -1) {
            System.out.println("************ invalid relation: " + r.rid);
            return;
        }
        if (this.pass == 1) {
            this.relIndexMap.put(r.rid, ridx);
        }
        if (this.pass == 1 && ridx == 16) {
            int nways = r.ways.size();
            for (int i = 0; i < nways; ++i) {
                this.bigRelMemberMap.put(r.ways.get(i), 0);
            }
        }
        if (this.pass == 4) {
            r.writeTo(this.getOutStreamForTile(ridx));
        }
    }

    @Override
    public void relationFileEnd(File relFile) throws Exception {
        System.out.println("relFileEnd pass=" + this.pass);
        this.closeTileOutStreams();
        if (this.pass == 4) {
            relFile.delete();
            File parentRels = new File(this.outTileDir, this.getNameForTile(16));
            if (parentRels.exists()) {
                parentRels.renameTo(relFile);
            }
        }
    }

    private int getLocaleIndexForNid(long nid) {
        this.templateNode.nid = nid;
        NodeData n = this.nodeMap.get(this.templateNode);
        if (n == null) {
            throw new IllegalArgumentException("nid=" + nid + " not found");
        }
        n.used = true;
        return n.localeIndex;
    }

    private int getTileIndex(NodeData n) {
        int idxLon = n.ilon >> 26 - this.level & 3;
        int idxLat = n.ilat >> 26 - this.level & 3;
        return 4 * idxLon + idxLat;
    }

    private int getTileIndex(WayData w) {
        int nnodes = w.nodes.size();
        int wayTileIndex = 16;
        for (int i = 0; i < nnodes; ++i) {
            int tileIndex = this.nodeIndexMap.getInt(w.nodes.get(i));
            if (tileIndex == -1) {
                return -1;
            }
            if (wayTileIndex == 16) {
                wayTileIndex = tileIndex;
                continue;
            }
            if (tileIndex == wayTileIndex) continue;
            return 16;
        }
        return wayTileIndex;
    }

    private int getTileIndex(RelationData r) {
        int nways = r.ways.size();
        int relTileIndex = 16;
        boolean hasAny = false;
        for (int i = 0; i < nways; ++i) {
            int tileIndex = this.wayIndexMap.getInt(r.ways.get(i));
            if (tileIndex == -1) continue;
            hasAny = true;
            if (relTileIndex == 16) {
                relTileIndex = tileIndex;
                continue;
            }
            if (tileIndex == relTileIndex) continue;
            return 16;
        }
        return hasAny ? relTileIndex : -1;
    }

    @Override
    protected String getNameForTile(int tileIndex) {
        if (tileIndex == 16) {
            return "parent." + this.typeSuffix;
        }
        int idxLon = this.baseLon * 4 + (tileIndex >> 2);
        int idxLat = this.baseLat * 4 + (tileIndex & 3);
        return idxLon + "_" + idxLat + "." + this.typeSuffix;
    }
}

